/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.app.update.UpdateManager;
import nextapp.echo2.webcontainer.ContainerContext;
import nextapp.echo2.webcontainer.ContainerContextImpl;
import nextapp.echo2.webcontainer.DefaultServerDelayMessage;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.WebContainerServlet;
import nextapp.echo2.webcontainer.util.IdTable;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.UserInstance;

public class ContainerInstance
extends UserInstance {
    private static final int DEFAULT_CALLBACK_INTERVAL = 500;
    private ApplicationInstance applicationInstance;
    private Map componentToRenderStateMap = new HashMap();
    private transient IdTable idTable;
    private boolean initialized = false;
    private Map initialRequestParameterMap;
    private transient Map taskQueueToCallbackIntervalMap;

    public static String getElementId(Component component) {
        return "c_" + component.getRenderId();
    }

    public static void newInstance(Connection conn) {
        new ContainerInstance(conn);
    }

    private ContainerInstance(Connection conn) {
        super(conn);
        this.setServerDelayMessage(DefaultServerDelayMessage.INSTANCE);
        this.initialRequestParameterMap = new HashMap(conn.getRequest().getParameterMap());
    }

    public ApplicationInstance getApplicationInstance() {
        return this.applicationInstance;
    }

    public int getCallbackInterval() {
        if (this.taskQueueToCallbackIntervalMap == null || this.taskQueueToCallbackIntervalMap.size() == 0) {
            return 500;
        }
        Iterator it = this.taskQueueToCallbackIntervalMap.values().iterator();
        int returnInterval = Integer.MAX_VALUE;
        while (it.hasNext()) {
            int interval = (Integer)it.next();
            if (interval >= returnInterval) continue;
            returnInterval = interval;
        }
        return returnInterval;
    }

    public Component getComponentByElementId(String elementId) {
        try {
            return this.applicationInstance.getComponentByRenderId(elementId.substring(2));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Invalid component element id: " + elementId);
        }
    }

    public IdTable getIdTable() {
        if (this.idTable == null) {
            this.idTable = new IdTable();
        }
        return this.idTable;
    }

    public Map getInitialRequestParameterMap() {
        return this.initialRequestParameterMap;
    }

    public RenderState getRenderState(Component component) {
        return (RenderState)this.componentToRenderStateMap.get(component);
    }

    public UpdateManager getUpdateManager() {
        return this.applicationInstance.getUpdateManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Connection conn) {
        if (this.initialized) {
            throw new IllegalStateException("Attempt to invoke ContainerInstance.init() on initialized instance.");
        }
        WebContainerServlet servlet = (WebContainerServlet)conn.getServlet();
        this.applicationInstance = servlet.newApplicationInstance();
        ContainerContextImpl containerContext = new ContainerContextImpl(this);
        this.applicationInstance.setContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME, (Object)containerContext);
        try {
            ApplicationInstance.setActive((ApplicationInstance)this.applicationInstance);
            this.applicationInstance.doInit();
        }
        finally {
            ApplicationInstance.setActive(null);
        }
        this.initialized = true;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void removeRenderState(Component component) {
        this.componentToRenderStateMap.remove(component);
    }

    public void setRenderState(Component component, RenderState renderState) {
        this.componentToRenderStateMap.put(component, renderState);
    }

    public void setTaskQueueCallbackInterval(TaskQueueHandle taskQueue, int ms) {
        if (this.taskQueueToCallbackIntervalMap == null) {
            this.taskQueueToCallbackIntervalMap = new WeakHashMap();
        }
        this.taskQueueToCallbackIntervalMap.put(taskQueue, new Integer(ms));
    }

    public void sessionDidActivate(HttpSessionEvent e) {
        super.sessionDidActivate(e);
        if (this.applicationInstance != null) {
            this.applicationInstance.activate();
        }
    }

    public void sessionWillPassivate(HttpSessionEvent e) {
        if (this.applicationInstance != null) {
            this.applicationInstance.passivate();
        }
        super.sessionWillPassivate(e);
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        if (this.applicationInstance != null) {
            this.applicationInstance.dispose();
        }
        super.valueUnbound(e);
    }
}

