/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.propertyrender;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Font;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.output.CssStyle;

public class FontRender {
    public static String renderFontFamilyCssAttributeValue(Font.Typeface typeface) {
        StringBuffer out = new StringBuffer(typeface.getName());
        for (typeface = typeface.getAlternate(); typeface != null; typeface = typeface.getAlternate()) {
            out.append(",");
            out.append(typeface.getName());
        }
        return out.toString();
    }

    public static String renderFontStyleCssAttributeValue(Font font) {
        return font.isItalic() ? "italic" : "normal";
    }

    public static String renderFontWeightCssAttributeValue(Font font) {
        return font.isBold() ? "bold" : "normal";
    }

    public static String renderTextDecorationCssAttributeValue(Font font) {
        StringBuffer out = new StringBuffer();
        if (font.isUnderline()) {
            out.append("underline");
        }
        if (font.isOverline()) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append("overline");
        }
        if (font.isLineThrough()) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append("line-through");
        }
        if (out.length() == 0) {
            return "none";
        }
        return out.toString();
    }

    public static void renderToStyle(CssStyle cssStyle, Component component) {
        FontRender.renderToStyle(cssStyle, (Font)component.getRenderProperty("font"));
    }

    public static void renderToStyle(CssStyle cssStyle, Font font) {
        if (font == null) {
            return;
        }
        Font.Typeface typeface = font.getTypeface();
        if (typeface != null) {
            cssStyle.setAttribute("font-family", FontRender.renderFontFamilyCssAttributeValue(typeface));
        }
        if (font.getSize() != null) {
            cssStyle.setAttribute("font-size", ExtentRender.renderCssAttributeValue(font.getSize()));
        }
        if (!font.isPlain()) {
            if (font.isBold()) {
                cssStyle.setAttribute("font-weight", "bold");
            }
            if (font.isItalic()) {
                cssStyle.setAttribute("font-style", "italic");
            }
            if (font.isUnderline() || font.isOverline() || font.isLineThrough()) {
                StringBuffer out = new StringBuffer();
                if (font.isUnderline()) {
                    out.append("underline");
                }
                if (font.isOverline()) {
                    if (out.length() > 0) {
                        out.append(" ");
                    }
                    out.append("overline");
                }
                if (font.isLineThrough()) {
                    if (out.length() > 0) {
                        out.append(" ");
                    }
                    out.append("line-through");
                }
                cssStyle.setAttribute("text-decoration", out.toString());
            }
        }
    }

    private FontRender() {
    }
}

