/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.ColumnLayoutData;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.partialupdate.BorderUpdate;
import nextapp.echo2.webcontainer.partialupdate.ColorUpdate;
import nextapp.echo2.webcontainer.partialupdate.InsetsUpdate;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumnPeer
implements ComponentSynchronizePeer,
DomUpdateSupport,
ImageRenderSupport {
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public ColumnPeer() {
        this.partialUpdateManager.add("border", new BorderUpdate("border", null, "border"));
        this.partialUpdateManager.add("foreground", new ColorUpdate("foreground", null, "color"));
        this.partialUpdateManager.add("background", new ColorUpdate("background", null, "backgroundColor"));
        this.partialUpdateManager.add("insets", new InsetsUpdate("insets", null, "padding"));
    }

    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_cell_" + ContainerInstance.getElementId(child);
    }

    public ImageReference getImage(Component component, String imageId) {
        return CellLayoutDataRender.getCellLayoutDataBackgroundImage(component, imageId);
    }

    private ColumnLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof ColumnLayoutData) {
            return (ColumnLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Column Child: " + layoutData.getClass().getName());
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    private void renderAddChild(RenderContext rc, ServerComponentUpdate update, Element parentElement, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, parentElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    private void renderAddChildren(RenderContext rc, ServerComponentUpdate update) {
        int previousLastChildIndex;
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        Column column = (Column)update.getParent();
        String elementId = ContainerInstance.getElementId((Component)column);
        Component[] components = update.getParent().getVisibleComponents();
        Component[] addedChildren = update.getAddedChildren();
        for (int componentIndex = components.length - 1; componentIndex >= 0; --componentIndex) {
            boolean childFound = false;
            for (int addedChildrenIndex = 0; !childFound && addedChildrenIndex < addedChildren.length; ++addedChildrenIndex) {
                if (addedChildren[addedChildrenIndex] != components[componentIndex]) continue;
                DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
                this.renderChild(rc, update, htmlFragment, (Component)column, components[componentIndex]);
                if (componentIndex == components.length - 1) {
                    DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)elementId, (DocumentFragment)htmlFragment);
                } else {
                    DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)elementId, (String)(elementId + "_cell_" + ContainerInstance.getElementId(components[componentIndex + 1])), (DocumentFragment)htmlFragment);
                }
                childFound = true;
            }
        }
        ColumnPeerRenderState renderState = (ColumnPeerRenderState)rc.getContainerInstance().getRenderState((Component)column);
        if (renderState != null && renderState.lastChild != null && (previousLastChildIndex = column.visibleIndexOf(renderState.lastChild)) != -1 && previousLastChildIndex != column.getVisibleComponentCount() - 1) {
            boolean lastChildMoved = false;
            for (int i = 0; i < addedChildren.length; ++i) {
                if (renderState.lastChild != addedChildren[i]) continue;
                lastChildMoved = true;
            }
            if (!lastChildMoved) {
                DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
                this.renderSpacingCell(htmlFragment, column, renderState.lastChild);
                DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)elementId, (String)(elementId + "_cell_" + ContainerInstance.getElementId(components[previousLastChildIndex + 1])), (DocumentFragment)htmlFragment);
            }
        }
    }

    private void renderChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component, Component child) {
        Document document = parentNode.getOwnerDocument();
        String childId = ContainerInstance.getElementId(child);
        Element divElement = document.createElement("div");
        String cellId = ContainerInstance.getElementId(component) + "_cell_" + childId;
        divElement.setAttribute("id", cellId);
        CssStyle cssStyle = new CssStyle();
        ColumnLayoutData layoutData = this.getLayoutData(child);
        CellLayoutDataRender.renderToElementAndStyle(divElement, cssStyle, child, (CellLayoutData)layoutData, "0px");
        CellLayoutDataRender.renderBackgroundImageToStyle(cssStyle, rc, this, component, child);
        if (layoutData != null) {
            ExtentRender.renderToStyle(cssStyle, "height", layoutData.getHeight());
        }
        divElement.setAttribute("style", cssStyle.renderInline());
        parentNode.appendChild(divElement);
        this.renderSpacingCell(parentNode, (Column)component, child);
        this.renderAddChild(rc, update, divElement, child);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        Column column = (Column)component;
        Document document = parentNode.getOwnerDocument();
        Element divElement = document.createElement("div");
        divElement.setAttribute("id", ContainerInstance.getElementId((Component)column));
        CssStyle divCssStyle = new CssStyle();
        BorderRender.renderToStyle(divCssStyle, (Border)column.getRenderProperty("border"));
        ColorRender.renderToStyle(divCssStyle, (Color)column.getRenderProperty("foreground"), (Color)column.getRenderProperty("background"));
        FontRender.renderToStyle(divCssStyle, (Font)column.getRenderProperty("font"));
        Insets insets = (Insets)column.getRenderProperty("insets");
        if (insets == null) {
            divCssStyle.setAttribute("padding", "0px");
        } else {
            InsetsRender.renderToStyle(divCssStyle, "padding", insets);
        }
        divElement.setAttribute("style", divCssStyle.renderInline());
        parentNode.appendChild(divElement);
        Component[] children = column.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderChild(rc, update, divElement, component, children[i]);
        }
        this.storeRenderState(rc, (Component)column);
    }

    private void renderRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        Component[] removedChildren = update.getRemovedChildren();
        Component parent = update.getParent();
        String parentId = ContainerInstance.getElementId(parent);
        for (int i = 0; i < removedChildren.length; ++i) {
            String childId = ContainerInstance.getElementId(removedChildren[i]);
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)(parentId + "_cell_" + childId));
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)(parentId + "_spacing_" + childId));
        }
        int componentCount = parent.getVisibleComponentCount();
        if (componentCount > 0) {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)(parentId + "_spacing_" + ContainerInstance.getElementId(parent.getVisibleComponent(componentCount - 1))));
        }
    }

    private void renderSpacingCell(Node parentNode, Column column, Component child) {
        Extent cellSpacing = (Extent)column.getRenderProperty("cellSpacing");
        if (!ExtentRender.isZeroLength(cellSpacing) && column.visibleIndexOf(child) != column.getVisibleComponentCount() - 1) {
            Element spacingElement = parentNode.getOwnerDocument().createElement("div");
            spacingElement.setAttribute("id", ContainerInstance.getElementId((Component)column) + "_spacing_" + ContainerInstance.getElementId(child));
            CssStyle spacingCssStyle = new CssStyle();
            spacingCssStyle.setAttribute("height", ExtentRender.renderCssAttributeValue(cellSpacing));
            spacingCssStyle.setAttribute("font-size", "1px");
            spacingCssStyle.setAttribute("line-height", "0px");
            spacingElement.setAttribute("style", spacingCssStyle.renderInline());
            parentNode.appendChild(spacingElement);
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            if (update.hasRemovedChildren()) {
                this.renderRemoveChildren(rc, update);
            }
            if (update.hasUpdatedProperties()) {
                this.partialUpdateManager.process(rc, update);
            }
            if (update.hasAddedChildren()) {
                this.renderAddChildren(rc, update);
            }
        }
        this.storeRenderState(rc, update.getParent());
        return fullReplace;
    }

    private void storeRenderState(RenderContext rc, Component component) {
        int componentCount = component.getVisibleComponentCount();
        ColumnPeerRenderState renderState = new ColumnPeerRenderState();
        if (componentCount > 0) {
            renderState.lastChild = component.getVisibleComponent(componentCount - 1);
        }
        rc.getContainerInstance().setRenderState(component, renderState);
    }

    private static class ColumnPeerRenderState
    implements RenderState {
        public Component lastChild;

        private ColumnPeerRenderState() {
        }
    }
}

