/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.PasswordField;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.text.TextComponent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.syncpeer.TextComponentPeer;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextFieldPeer
extends TextComponentPeer
implements DomUpdateSupport {
    public void renderHtml(RenderContext rc, ServerComponentUpdate addUpdate, Node parentNode, Component component) {
        CssStyle cssStyle;
        Integer maximumLength;
        TextField textField = (TextField)component;
        String elementId = ContainerInstance.getElementId((Component)textField);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TEXT_COMPONENT_SERVICE.getId());
        Element inputElement = parentNode.getOwnerDocument().createElement("input");
        inputElement.setAttribute("id", elementId);
        if (textField instanceof PasswordField) {
            inputElement.setAttribute("type", "password");
        } else {
            inputElement.setAttribute("type", "text");
        }
        String value = textField.getText();
        if (value != null) {
            inputElement.setAttribute("value", value);
        }
        if (textField.isFocusTraversalParticipant()) {
            inputElement.setAttribute("tabindex", Integer.toString(textField.getFocusTraversalIndex()));
        } else {
            inputElement.setAttribute("tabindex", "-1");
        }
        String toolTipText = (String)textField.getRenderProperty("toolTipText");
        if (toolTipText != null) {
            inputElement.setAttribute("title", toolTipText);
        }
        if ((maximumLength = (Integer)textField.getRenderProperty("maximumLength")) != null) {
            inputElement.setAttribute("maxlength", maximumLength.toString());
        }
        if ((cssStyle = this.createBaseCssStyle(rc, (TextComponent)textField)).hasAttributes()) {
            inputElement.setAttribute("style", cssStyle.renderInline());
        }
        parentNode.appendChild(inputElement);
        this.renderInitDirective(rc, (TextComponent)textField);
    }
}

