/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RootSynchronizePeer;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.WindowUpdate;

public class WindowPeer
implements RootSynchronizePeer {
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public WindowPeer() {
        this.partialUpdateManager.add("title", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                Window window = (Window)update.getParent();
                String title = (String)window.getRenderProperty("title");
                WindowUpdate.renderSetWindowTitle((ServerMessage)rc.getServerMessage(), (String)title);
            }
        });
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        throw new UnsupportedOperationException("Cannot add window.");
    }

    public String getContainerId(Component child) {
        return "c_root";
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
    }

    public void renderRefresh(RenderContext rc, ServerComponentUpdate update, Component component) {
        Window window = (Window)component;
        String title = (String)window.getRenderProperty("title");
        if (title != null) {
            WindowUpdate.renderSetWindowTitle((ServerMessage)rc.getServerMessage(), (String)title);
        }
        DomUpdate.renderElementRemoveChildren((ServerMessage)rc.getServerMessage(), (String)"c_root");
        Component[] addedChildren = window.getVisibleComponents();
        for (int i = 0; i < addedChildren.length; ++i) {
            ComponentSynchronizePeer childSyncPeer = SynchronizePeerFactory.getPeerForComponent(addedChildren[i].getClass());
            childSyncPeer.renderAdd(rc, update, "c_root", addedChildren[i]);
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullRefresh = update.hasAddedChildren() || update.hasRemovedChildren() || update.hasUpdatedLayoutDataChildren() ? true : !update.hasUpdatedProperties() || !this.partialUpdateManager.canProcess(rc, update);
        if (fullRefresh) {
            this.renderRefresh(rc, update, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
        }
        return fullRefresh;
    }
}

