/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.BranchAddDependency;
import org.mindswap.pellet.BranchDependency;
import org.mindswap.pellet.ClashDependency;
import org.mindswap.pellet.CloseBranchDependency;
import org.mindswap.pellet.Dependency;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.MergeDependency;
import org.mindswap.pellet.TypeDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyEntry {
    private Set<Dependency> types = new HashSet<Dependency>();
    private Set<Dependency> merges;
    private Set<Edge> edges = new HashSet<Edge>();
    private Set<Dependency> branchAdds;
    private Set<Dependency> branchCloses;
    private ClashDependency clash = null;

    public DependencyEntry() {
        this.merges = new HashSet<Dependency>();
        this.branchAdds = new HashSet<Dependency>();
        this.branchCloses = new HashSet<Dependency>();
    }

    public DependencyEntry copy() {
        DependencyEntry newEntry = new DependencyEntry();
        newEntry.types = new HashSet<Dependency>(this.types);
        newEntry.merges = new HashSet<Dependency>(this.merges);
        for (Edge next : this.edges) {
            Edge newEdge = new Edge(next.getRole(), next.getFrom(), next.getTo(), next.getDepends().copy());
            newEntry.edges.add(newEdge);
        }
        newEntry.branchAdds = new HashSet<Dependency>(this.branchAdds);
        newEntry.branchCloses = new HashSet<Dependency>(this.branchCloses);
        newEntry.clash = this.clash;
        return newEntry;
    }

    protected void addTypeDependency(ATermAppl ind, ATermAppl type) {
        this.types.add(new TypeDependency(ind, type));
    }

    protected void addEdgeDependency(Edge edge) {
        this.edges.add(edge);
    }

    protected void addMergeDependency(ATermAppl ind, ATermAppl mergedTo) {
        this.merges.add(new MergeDependency(ind, mergedTo));
    }

    protected BranchDependency addBranchAddDependency(ATermAppl assertion, int branchId, Branch branch) {
        BranchAddDependency b = new BranchAddDependency(assertion, branchId, branch);
        this.branchAdds.add(b);
        return b;
    }

    protected BranchDependency addCloseBranchDependency(ATermAppl assertion, Branch theBranch) {
        CloseBranchDependency b = new CloseBranchDependency(assertion, theBranch.tryNext, theBranch);
        if (this.branchCloses.contains(b)) {
            this.branchCloses.remove(b);
        }
        this.branchCloses.add(b);
        return b;
    }

    public void print() {
        System.out.println("  Edge Dependencies:");
        Iterator<Object> it = this.edges.iterator();
        while (it.hasNext()) {
            System.out.println("    " + it.next().toString());
        }
        System.out.println("  Type Dependencies:");
        it = this.types.iterator();
        while (it.hasNext()) {
            System.out.println("    " + ((TypeDependency)it.next()).toString());
        }
        System.out.println("  Merge Dependencies:");
        it = this.merges.iterator();
        while (it.hasNext()) {
            System.out.println("    " + ((MergeDependency)it.next()).toString());
        }
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Set<Dependency> getMerges() {
        return this.merges;
    }

    public Set<Dependency> getTypes() {
        return this.types;
    }

    public Set<Dependency> getBranchAdds() {
        return this.branchAdds;
    }

    public Set<Dependency> getCloseBranches() {
        return this.branchCloses;
    }

    protected ClashDependency getClash() {
        return this.clash;
    }

    protected void setClash(ClashDependency clash) {
        this.clash = clash;
    }
}

