/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.DependencyIndex;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencySet {
    public static final int NO_BRANCH = -1;
    public static final DependencySet EMPTY = new DependencySet();
    public static final DependencySet INDEPENDENT = new DependencySet(0);
    public static final BitSet ZERO = new BitSet();
    public static final DependencySet DUMMY;
    private BitSet depends;
    int branch = -1;
    Set<ATermAppl> explain;

    private DependencySet() {
        this.depends = new BitSet();
        this.explain = SetUtils.emptySet();
    }

    public DependencySet(int branch) {
        this.depends = new BitSet();
        this.depends.set(branch);
        this.explain = SetUtils.emptySet();
    }

    public DependencySet(BitSet depends, Set<ATermAppl> explain) {
        this.depends = depends;
        this.explain = explain;
    }

    public DependencySet(ATermAppl explainAtom) {
        this.depends = ZERO;
        this.explain = SetUtils.singleton(explainAtom);
    }

    public DependencySet(Set<ATermAppl> explain) {
        this.depends = ZERO;
        this.explain = explain;
    }

    public DependencySet copy() {
        return new DependencySet(this.depends, this.explain);
    }

    public boolean contains(int b) {
        return this.depends.get(b);
    }

    public void add(int b) {
        this.depends.set(b);
    }

    public void remove(int b) {
        this.depends.clear(b);
    }

    public boolean isIndependent() {
        return this.max() <= 0;
    }

    public int size() {
        return this.depends.cardinality();
    }

    public int max() {
        return this.depends.length() - 1;
    }

    public Set getExplanationSet() {
        return Collections.unmodifiableSet(this.explain);
    }

    public DependencySet union(DependencySet ds, boolean doExplanation) {
        BitSet newDepends = (BitSet)this.depends.clone();
        newDepends.or(ds.depends);
        Set<ATermAppl> newExplain = doExplanation ? SetUtils.union(this.explain, ds.explain) : SetUtils.emptySet();
        return new DependencySet(newDepends, newExplain);
    }

    public DependencySet addExplain(Set<ATermAppl> explain, boolean doExplanation) {
        if (!doExplanation || explain.isEmpty()) {
            return this;
        }
        BitSet newDepends = (BitSet)this.depends.clone();
        Set<ATermAppl> newExplain = SetUtils.union(this.explain, explain);
        return new DependencySet(newDepends, newExplain);
    }

    public String toString() {
        return "[" + this.branch + "-" + this.depends.toString() + "]";
    }

    public void removeExplain(ATermAppl assertion) {
        if (this.explain.contains(assertion)) {
            this.explain = new HashSet<ATermAppl>();
            if (DependencyIndex.log.isDebugEnabled()) {
                DependencyIndex.log.debug((Object)"             Explain: removed ");
            }
        }
    }

    public void setDepends(BitSet depends) {
        this.depends = depends;
    }

    public BitSet getDepends() {
        return this.depends;
    }

    static {
        ZERO.set(0);
        DUMMY = new DependencySet(1);
    }
}

