/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.Set;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class IndividualsExample {
    public static void main(String[] args) throws Exception {
        System.out.println("Results using Jena interface");
        System.out.println("----------------------------");
        IndividualsExample.runWithJena();
        System.out.println("Results using OWL-API interface");
        System.out.println("-------------------------------");
        IndividualsExample.runWithOWLAPI();
    }

    public static void runWithJena() {
        String ont = "http://www.mindswap.org/2004/owl/mindswappers#";
        ModelReader reader = new ModelReader();
        Model model = reader.read(ont);
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.load(model);
        Property Person = model.getProperty("http://xmlns.com/foaf/0.1/Person");
        Property workHomepage = model.getProperty("http://xmlns.com/foaf/0.1/workInfoHomepage");
        Property foafName = model.getProperty("http://xmlns.com/foaf/0.1/name");
        Set individuals = reasoner.getInstances((Resource)Person);
        for (Resource ind : individuals) {
            String name = ((Literal)reasoner.getPropertyValue(foafName, (RDFNode)ind)).getString();
            Resource type = reasoner.getType(ind, true);
            Resource homepage = (Resource)reasoner.getPropertyValue(workHomepage, (RDFNode)ind);
            System.out.println("Name: " + name);
            System.out.println("Type: " + type.getLocalName());
            if (homepage == null) {
                System.out.println("Homepage: Unknown");
            } else {
                System.out.println("Homepage: " + homepage);
            }
            System.out.println();
        }
    }

    public static void runWithOWLAPI() throws OWLException {
        String ont = "http://www.mindswap.org/2004/owl/mindswappers#";
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = manager.loadOntology(URI.create(ont));
        Reasoner reasoner = new Reasoner(manager);
        reasoner.setOntology(ontology);
        OWLClass Person = factory.getOWLClass(URI.create("http://xmlns.com/foaf/0.1/Person"));
        OWLObjectProperty workHomepage = factory.getOWLObjectProperty(URI.create("http://xmlns.com/foaf/0.1/workInfoHomepage"));
        OWLDataProperty foafName = factory.getOWLDataProperty(URI.create("http://xmlns.com/foaf/0.1/name"));
        Set<OWLIndividual> individuals = reasoner.getIndividuals((OWLDescription)Person, false);
        for (OWLIndividual ind : individuals) {
            String name = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)foafName).getLiteral();
            OWLClass type = reasoner.getType(ind);
            OWLIndividual homepage = reasoner.getRelatedIndividual(ind, (OWLObjectPropertyExpression)workHomepage);
            System.out.println("Name: " + name);
            System.out.println("Type: " + type.getURI().getFragment());
            if (homepage == null) {
                System.out.println("Homepage: Unknown");
            } else {
                System.out.println("Homepage: " + homepage.getURI());
            }
            System.out.println();
        }
    }
}

