/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.MultiIterator;
import org.mindswap.pellet.jena.OWLLoader;
import org.mindswap.pellet.utils.ATermUtils;

public class DisjointMultiUnion
extends MultiUnion
implements GraphListener {
    private boolean listenChanges;
    private boolean deletion = false;
    private Set changedGraphs = new HashSet();
    private boolean unsupportedChange;
    private KnowledgeBase kb;
    private OWLLoader loader;

    public DisjointMultiUnion() {
        this(false, null, null);
    }

    public DisjointMultiUnion(boolean listenChanges, KnowledgeBase kb, OWLLoader loader) {
        this.listenChanges = listenChanges;
        this.kb = kb;
        this.unsupportedChange = false;
        this.loader = loader;
    }

    public DisjointMultiUnion(Graph graph) {
        this(true, null, null);
        this.addGraph(graph);
    }

    public DisjointMultiUnion(Graph graph, KnowledgeBase kb, OWLLoader loader) {
        this(false, kb, loader);
        this.addGraph(graph);
    }

    public boolean isEmpty() {
        Iterator i = this.m_subGraphs.iterator();
        while (i.hasNext()) {
            if (((Graph)i.next()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ExtendedIterator graphBaseFind(TripleMatch t) {
        Iterator graphs = this.m_subGraphs.iterator();
        if (!graphs.hasNext()) {
            return NullIterator.instance;
        }
        Graph firstG = (Graph)graphs.next();
        MultiIterator i = new MultiIterator((Iterator)firstG.find(t));
        while (graphs.hasNext()) {
            Graph nextG = (Graph)graphs.next();
            i = i.andThen((ClosableIterator)nextG.find(t));
        }
        return i;
    }

    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            if (graph instanceof MultiUnion) {
                MultiUnion union = (MultiUnion)graph;
                if (union.getBaseGraph() != null) {
                    this.addGraph(union.getBaseGraph());
                }
                Iterator i = union.getSubGraphs().iterator();
                while (i.hasNext()) {
                    this.addGraph((Graph)i.next());
                }
            } else if (graph instanceof InfGraph) {
                this.addGraph(((InfGraph)graph).getRawGraph());
            } else {
                this.m_subGraphs.add(graph);
                if (this.listenChanges) {
                    graph.getEventManager().register((GraphListener)this);
                }
            }
        }
    }

    public void releaseListeners() {
        for (Graph graph : this.m_subGraphs) {
            graph.getEventManager().unregister((GraphListener)this);
        }
    }

    public void notifyAddTriple(Graph g, Triple t) {
        boolean canUseInc;
        boolean bl = canUseInc = this.canUseIncAdd() ? this.isABoxChange(t) : false;
        if (canUseInc) {
            this.addABoxChange(t);
        } else {
            this.changedGraphs.add(g);
        }
    }

    public void notifyAddArray(Graph g, Triple[] triples) {
        boolean canUseInc;
        boolean bl = canUseInc = this.canUseIncAdd() ? this.isABoxChange(triples) : false;
        if (canUseInc) {
            for (int i = 0; i < triples.length; ++i) {
                this.addABoxChange(triples[i]);
            }
        } else {
            this.changedGraphs.add(g);
        }
    }

    public void notifyAddList(Graph g, List triples) {
        boolean canUseInc;
        boolean bl = canUseInc = this.canUseIncAdd() ? this.isABoxChange(triples) : false;
        if (canUseInc) {
            for (int i = 0; i < triples.size(); ++i) {
                this.addABoxChange((Triple)triples.get(i));
            }
        } else {
            this.changedGraphs.add(g);
        }
    }

    public void notifyAddIterator(Graph g, Iterator it) {
        boolean canUseInc;
        boolean bl = canUseInc = this.canUseIncAdd() ? this.isABoxChange(it) : false;
        if (canUseInc) {
            while (it.hasNext()) {
                this.addABoxChange((Triple)it.next());
            }
        } else {
            this.changedGraphs.add(g);
        }
    }

    public void notifyAddGraph(Graph g, Graph added) {
        boolean canUseInc;
        boolean bl = canUseInc = this.canUseIncAdd() ? this.isABoxChange(added) : false;
        if (canUseInc) {
            ExtendedIterator i = added.find((TripleMatch)Triple.ANY);
            while (i.hasNext()) {
                this.addABoxChange((Triple)i.next());
            }
        } else {
            this.changedGraphs.add(g);
        }
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.deletion = true;
    }

    public void notifyDeleteList(Graph g, List L) {
        this.deletion |= !L.isEmpty();
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.deletion |= triples.length > 0;
    }

    public void notifyDeleteIterator(Graph g, Iterator it) {
        this.deletion |= it.hasNext();
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.deletion = true;
    }

    public void notifyEvent(Graph source, Object value) {
        this.deletion = true;
    }

    public boolean isStatementDeleted() {
        return this.deletion;
    }

    public void resetChanged() {
        this.unsupportedChange = false;
        this.deletion = false;
        this.changedGraphs.clear();
    }

    public DisjointMultiUnion minus(DisjointMultiUnion other) {
        if (!this.m_subGraphs.containsAll(other.m_subGraphs)) {
            return null;
        }
        DisjointMultiUnion diff = new DisjointMultiUnion();
        for (Graph g : this.m_subGraphs) {
            if (other.m_subGraphs.contains(g) && !other.changedGraphs.contains(g)) continue;
            diff.addGraph(g);
        }
        return diff;
    }

    public boolean isABoxChange(Triple t) {
        Node o = t.getObject();
        Node p = t.getPredicate();
        if (p.getURI().equals(RDF.type.toString())) {
            if (o.isBlank()) {
                this.unsupportedChange = true;
                return false;
            }
            ATermAppl object = ATermUtils.makeTermAppl(o.getURI());
            if (!this.kb.getClasses().contains(object)) {
                this.unsupportedChange = true;
                return false;
            }
        } else {
            ATermAppl prop = ATermUtils.makeTermAppl(p.getURI());
            if (!this.kb.isProperty(prop)) {
                this.unsupportedChange = true;
                return false;
            }
        }
        return true;
    }

    public boolean isABoxChange(Triple[] triples) {
        boolean satisfied = true;
        for (int i = 0; i < triples.length; ++i) {
            Triple t = triples[i];
            if (this.isABoxChange(t)) continue;
            satisfied = false;
            break;
        }
        return satisfied;
    }

    public boolean isABoxChange(List triples) {
        boolean satisfied = true;
        for (int i = 0; i < triples.size(); ++i) {
            Triple t = (Triple)triples.get(i);
            if (this.isABoxChange(t)) continue;
            satisfied = false;
            break;
        }
        return satisfied;
    }

    public boolean isABoxChange(Iterator triples) {
        boolean satisfied = true;
        while (triples.hasNext()) {
            Triple t = (Triple)triples.next();
            if (this.isABoxChange(t)) continue;
            satisfied = false;
            break;
        }
        return satisfied;
    }

    public boolean isABoxChange(Graph graph) {
        boolean satisfied = true;
        ExtendedIterator i = graph.find((TripleMatch)Triple.ANY);
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            if (this.isABoxChange(t)) continue;
            satisfied = false;
            break;
        }
        return satisfied;
    }

    public boolean canUseIncAdd() {
        return this.kb != null && !this.unsupportedChange && this.loader != null;
    }

    public void addABoxChange(Triple t) {
        ATermAppl s = this.loader.node2term(t.getSubject());
        ATermAppl p = this.loader.node2term(t.getPredicate());
        ATermAppl o = this.loader.node2term(t.getObject());
        if (p.toString().equals(RDF.type.toString())) {
            if (!this.kb.getIndividuals().contains(s)) {
                this.kb.addIndividual(s);
            }
            this.kb.addType(s, o);
        } else {
            if (!this.kb.getIndividuals().contains(s)) {
                this.kb.addIndividual(s);
            }
            if (!t.getObject().isLiteral() && !this.kb.getIndividuals().contains(o)) {
                this.kb.addIndividual(o);
            }
            this.kb.addPropertyValue(p, s, o);
        }
    }

    public void setLoader(OWLLoader loader) {
        this.loader = loader;
    }
}

