/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.UnknownDatatype;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.rules.model.AtomDConstant;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletVisitor
implements OWLObjectVisitor {
    private static final long serialVersionUID = 8211773146996997500L;
    public static Log log = LogFactory.getLog(PelletVisitor.class);
    private KnowledgeBase kb;
    private ATermAppl term;
    private AtomDObject swrlDObject;
    private AtomIObject swrlIObject;
    private RuleAtom swrlAtom;
    private ProgressMonitor monitor;
    private boolean addAxioms;
    private boolean reloadRequired;
    private Set<OWLAxiom> unsupportedAxioms;
    private MultiValueMap<OWLObjectProperty, OWLObjectPropertyAxiom> compositePropertyAxioms;
    private Set<OWLObjectProperty> simpleProperties;

    public PelletVisitor(KnowledgeBase kb) {
        this.kb = kb;
        this.clear();
    }

    public void clear() {
        this.unsupportedAxioms = new HashSet<OWLAxiom>();
        this.compositePropertyAxioms = new MultiValueMap();
        this.simpleProperties = new HashSet<OWLObjectProperty>();
    }

    private void addUnsupportedAxiom(OWLAxiom axiom) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException("Axiom: " + axiom);
        }
        if (this.unsupportedAxioms.add(axiom)) {
            log.warn((Object)("Ignoring unsupported axiom: " + axiom));
        }
    }

    private OWLObjectProperty getNamedProperty(OWLObjectPropertyExpression ope) {
        if (ope.isAnonymous()) {
            return this.getNamedProperty(((OWLObjectPropertyInverse)ope).getInverse());
        }
        return ope.asOWLObjectProperty();
    }

    private void addSimpleProperty(OWLObjectPropertyExpression ope) {
        OWLObjectProperty prop = this.getNamedProperty(ope);
        this.simpleProperties.add(prop);
        prop.accept((OWLObjectVisitor)this);
        Role role = this.kb.getRBox().getRole(this.term);
        role.setForceSimple(true);
    }

    void verify() {
        for (Map.Entry entry : this.compositePropertyAxioms.entrySet()) {
            OWLObjectProperty nonSimpleProperty = (OWLObjectProperty)entry.getKey();
            if (!this.simpleProperties.contains(nonSimpleProperty)) continue;
            Set axioms = (Set)entry.getValue();
            for (OWLObjectPropertyAxiom axiom : axioms) {
                this.addUnsupportedAxiom((OWLAxiom)axiom);
            }
            ATermAppl name = ATermUtils.term(nonSimpleProperty.getURI());
            Role role = this.kb.getRBox().getRole(name);
            role.removeSubRoleChains();
        }
    }

    public void setAddAxiom(boolean addAxioms) {
        this.addAxioms = addAxioms;
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public ATermAppl result() {
        return this.term;
    }

    public void reset() {
        this.term = null;
        this.reloadRequired = false;
    }

    public void visit(OWLClass c) {
        URI uri = c.getURI();
        this.term = uri.equals(OWLRDFVocabulary.OWL_THING.getURI()) ? ATermUtils.TOP : (uri.equals(OWLRDFVocabulary.OWL_NOTHING.getURI()) ? ATermUtils.BOTTOM : ATermUtils.term(uri));
        if (this.addAxioms) {
            this.kb.addClass(this.term);
        }
    }

    public void visit(OWLIndividual ind) {
        this.term = ATermUtils.term(ind.getURI());
        if (this.addAxioms) {
            this.kb.addIndividual(this.term);
        }
    }

    public void visit(OWLObjectProperty prop) {
        this.term = ATermUtils.term(prop.getURI());
        if (this.addAxioms) {
            this.kb.addObjectProperty(this.term);
        }
    }

    public void visit(OWLObjectPropertyInverse propInv) {
        propInv.getInverse().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.term = ATermUtils.makeInv(p);
    }

    public void visit(OWLDataProperty prop) {
        this.term = ATermUtils.term(prop.getURI());
        if (this.addAxioms) {
            this.kb.addDatatypeProperty(this.term);
        }
    }

    public void visit(OWLTypedConstant constant) {
        String lexicalValue = constant.getLiteral();
        constant.getDataType().accept((OWLObjectVisitor)this);
        ATermAppl datatype = this.term;
        this.term = ATermUtils.makeTypedLiteral(lexicalValue, datatype.toString());
    }

    public void visit(OWLUntypedConstant constant) {
        String lexicalValue = constant.getLiteral();
        String lang = constant.getLang();
        this.term = lang != null ? ATermUtils.makePlainLiteral(lexicalValue, lang) : ATermUtils.makePlainLiteral(lexicalValue);
    }

    public void visit(OWLDataType ocdt) {
        this.term = ATermUtils.term(ocdt.getURI());
        if (PelletOptions.AUTO_XML_SCHEMA_LOADING) {
            this.kb.loadDatatype(this.term);
        } else {
            this.kb.addDatatype(this.term);
        }
    }

    public void visit(OWLObjectIntersectionOf and) {
        Set operands = and.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDescription desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeAnd(setOfTerms);
    }

    public void visit(OWLObjectUnionOf or) {
        Set operands = or.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDescription desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLObjectComplementOf not) {
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot(this.term);
    }

    public void visit(OWLObjectOneOf enumeration) {
        Set operands = enumeration.getIndividuals();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLIndividual ind : operands) {
            ind.accept((OWLObjectVisitor)this);
            terms[size++] = ATermUtils.makeValue(this.term);
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLObjectSomeRestriction restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues(p, c);
    }

    public void visit(OWLObjectAllRestriction restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues(p, c);
    }

    public void visit(OWLObjectValueRestriction restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLIndividual)restriction.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        this.term = ATermUtils.makeHasValue(p, ind);
    }

    public void visit(OWLObjectExactCardinalityRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeCard(p, n, desc);
    }

    public void visit(OWLObjectMaxCardinalityRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLObjectMinCardinalityRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLDataExactCardinalityRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeCard(p, n, desc);
    }

    public void visit(OWLDataMaxCardinalityRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLDataMinCardinalityRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set descriptions = axiom.getDescriptions();
        int size = descriptions.size();
        if (size > 1) {
            ATermAppl[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLDescription desc : descriptions) {
                desc.accept((OWLObjectVisitor)this);
                terms[index++] = this.term;
            }
            Arrays.sort(terms, 0, size, Comparators.hashCodeComparator);
            ATermAppl c1 = terms[0];
            for (int i = 1; i < terms.length; ++i) {
                ATermAppl c2 = terms[i];
                if (this.addAxioms) {
                    this.kb.addEquivalentClass(c1, c2);
                    continue;
                }
                ATermAppl sameAxiom = ATermUtils.makeEqClasses(c1, c2);
                boolean bl = this.reloadRequired = !this.kb.removeAxiom(sameAxiom);
                if (!this.reloadRequired) continue;
                return;
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Set descriptions = axiom.getDescriptions();
        int size = descriptions.size();
        if (size > 1) {
            ATerm[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLDescription desc : descriptions) {
                desc.accept((OWLObjectVisitor)this);
                terms[index++] = this.term;
            }
            Arrays.sort(terms, 0, size, Comparators.hashCodeComparator);
            ATermList list = ATermUtils.toSet(terms, size);
            this.kb.addDisjointClasses(list);
        }
    }

    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        ATermAppl c1 = this.term;
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        ATermAppl c2 = this.term;
        if (this.addAxioms) {
            this.kb.addSubClass(c1, c2);
        } else {
            ATermAppl subAxiom = ATermUtils.makeSub(c1, c2);
            this.reloadRequired = !this.kb.removeAxiom(subAxiom);
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] eqs = axiom.getProperties().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLProperty prop1 = (OWLProperty)eqs[i];
                OWLProperty prop2 = (OWLProperty)eqs[j];
                prop1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                prop2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] eqs = axiom.getProperties().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLProperty prop1 = (OWLProperty)eqs[i];
                OWLProperty prop2 = (OWLProperty)eqs[j];
                prop1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                prop2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] inds = axiom.getIndividuals().toArray();
        for (int i = 0; i < inds.length; ++i) {
            ((OWLIndividual)inds[i]).accept((OWLObjectVisitor)this);
            ATermAppl i1 = this.term;
            for (int j = i + 1; j < inds.length; ++j) {
                ((OWLIndividual)inds[j]).accept((OWLObjectVisitor)this);
                ATermAppl i2 = this.term;
                this.kb.addDifferent(i1, i2);
            }
        }
    }

    public void visit(OWLSameIndividualsAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Iterator eqs = axiom.getIndividuals().iterator();
        if (eqs.hasNext()) {
            ((OWLIndividual)eqs.next()).accept((OWLObjectVisitor)this);
            ATermAppl i1 = this.term;
            while (eqs.hasNext()) {
                ((OWLIndividual)eqs.next()).accept((OWLObjectVisitor)this);
                ATermAppl i2 = this.term;
                this.kb.addSame(i1, i2);
            }
        }
    }

    public void visit(OWLDataOneOf enumeration) {
        ATermList ops = ATermUtils.EMPTY_LIST;
        for (OWLConstant value : enumeration.getValues()) {
            value.accept((OWLObjectVisitor)this);
            ops = ops.insert(ATermUtils.makeValue(this.result()));
        }
        this.term = ATermUtils.makeOr(ops);
    }

    public void visit(OWLDataAllRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues(p, c);
    }

    public void visit(OWLDataSomeRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues(p, c);
    }

    public void visit(OWLDataValueRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLConstant)restriction.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl dv = this.term;
        this.term = ATermUtils.makeHasValue(p, dv);
    }

    public void visit(OWLOntology ont) {
        for (OWLAxiom axiom : ont.getAxioms()) {
            this.monitor.incrementProgress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load " + axiom));
            }
            axiom.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLObjectSelfRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.term = ATermUtils.makeSelf(p);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] disjs = axiom.getProperties().toArray();
        for (int i = 0; i < disjs.length - 1; ++i) {
            OWLObjectProperty prop1 = (OWLObjectProperty)disjs[i];
            this.addSimpleProperty((OWLObjectPropertyExpression)prop1);
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLObjectProperty prop2 = (OWLObjectProperty)disjs[j];
                this.addSimpleProperty((OWLObjectPropertyExpression)prop2);
                prop1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                prop2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addDisjointProperty(p1, p2);
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] disjs = axiom.getProperties().toArray();
        for (int i = 0; i < disjs.length; ++i) {
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDescription desc1 = (OWLDescription)disjs[i];
                OWLDescription desc2 = (OWLDescription)disjs[j];
                desc1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                desc2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addDisjointProperty(p1, p2);
            }
        }
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty(axiom.getSuperProperty()), (OWLObjectPropertyAxiom)axiom);
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl prop = this.result();
        List propChain = axiom.getPropertyChain();
        ATermList chain = ATermUtils.EMPTY_LIST;
        for (int i = propChain.size() - 1; i >= 0; --i) {
            OWLObjectProperty p = (OWLObjectProperty)propChain.get(i);
            p.accept((OWLObjectVisitor)this);
            chain = chain.insert(this.result());
        }
        this.kb.addSubProperty(chain, prop);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        ATermList classes = ATermUtils.EMPTY_LIST;
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept((OWLObjectVisitor)this);
            classes = classes.insert(this.result());
        }
        this.kb.addDisjointClasses(classes);
        this.kb.addEquivalentClass(c, ATermUtils.makeOr(classes));
    }

    public void visit(OWLDataComplementOf node) {
        String name = "Datatype" + node.hashCode();
        DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
        Datatype datatype = UnknownDatatype.instance;
        node.getDataRange().accept((OWLObjectVisitor)this);
        Datatype baseDatatype = dtReasoner.getDatatype(this.term);
        datatype = dtReasoner.negate(baseDatatype);
        this.kb.addDatatype(name, datatype);
        this.term = ATermUtils.makeTermAppl(name);
    }

    public void visit(OWLDataRangeRestriction node) {
        String name = "Datatype" + node.hashCode();
        DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
        AtomicDatatype datatype = UnknownDatatype.instance;
        node.getDataRange().accept((OWLObjectVisitor)this);
        Datatype baseDatatype = dtReasoner.getDatatype(this.term);
        if (baseDatatype instanceof XSDAtomicType) {
            XSDAtomicType xsdType = (XSDAtomicType)baseDatatype;
            Set facets = node.getFacetRestrictions();
            for (OWLDataRangeFacetRestriction restr : facets) {
                OWLRestrictedDataRangeFacetVocabulary facet = restr.getFacet();
                OWLTypedConstant facetValue = restr.getFacetValue();
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE)) {
                    Object value = xsdType.getPrimitiveType().getValue(facetValue.getLiteral(), xsdType.getURI());
                    xsdType = xsdType.restrictMinInclusive(value);
                    continue;
                }
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE)) {
                    Object value = xsdType.getPrimitiveType().getValue(facetValue.getLiteral(), xsdType.getURI());
                    xsdType = xsdType.restrictMaxInclusive(value);
                    continue;
                }
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE)) {
                    Object value = xsdType.getPrimitiveType().getValue(facetValue.getLiteral(), xsdType.getURI());
                    xsdType = xsdType.restrictMinExclusive(value);
                    continue;
                }
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE)) {
                    Object value = xsdType.getPrimitiveType().getValue(facetValue.getLiteral(), xsdType.getURI());
                    xsdType = xsdType.restrictMaxExclusive(value);
                    continue;
                }
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.TOTAL_DIGITS)) {
                    int n = Integer.parseInt(facetValue.getLiteral());
                    xsdType = xsdType.restrictTotalDigits(n);
                    continue;
                }
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.FRACTION_DIGITS)) {
                    int n = Integer.parseInt(facetValue.getLiteral());
                    xsdType = xsdType.restrictFractionDigits(n);
                    continue;
                }
                if (facet.equals((Object)OWLRestrictedDataRangeFacetVocabulary.PATTERN)) {
                    String str = facetValue.getLiteral();
                    xsdType = xsdType.restrictPattern(str);
                    continue;
                }
                log.warn((Object)("Unrecognized facet " + facet));
            }
            datatype = xsdType;
        } else {
            log.warn((Object)("Unrecognized base datatype " + node.getDataRange()));
        }
        this.kb.addDatatype(name, datatype);
        this.term = ATermUtils.makeTermAppl(name);
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addAntisymmetricProperty(p);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addReflexiveProperty(p);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addFunctionalProperty(p);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addNegatedPropertyValue(p, s, o);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addDomain(p, c);
    }

    public void visit(OWLImportsDeclaration axiom) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring imports declaration: " + axiom));
        }
    }

    public void visit(OWLAxiomAnnotationAxiom axiom) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring axiom annotation: " + axiom));
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addDomain(p, c);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLConstant)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addNegatedPropertyValue(p, s, o);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDescription)axiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addRange(p, c);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl subj = this.term;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl pred = this.term;
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl obj = this.term;
        this.kb.addPropertyValue(pred, subj, obj);
    }

    public void visit(OWLObjectSubPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl sub = this.term;
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl sup = this.term;
        this.kb.addSubProperty(sub, sup);
    }

    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLEntityAnnotationAxiom axiom) {
        ((OWLEntity)axiom.getSubject()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLOntologyAnnotationAxiom axiom) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring ontology annotation: " + axiom));
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addSymmetricProperty(p);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addRange(p, c);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addFunctionalProperty(p);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        axiom.getDescription().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addType(ind, c);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl subj = this.term;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl pred = this.term;
        ((OWLConstant)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl obj = this.term;
        this.kb.addPropertyValue(pred, subj, obj);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty((OWLObjectPropertyExpression)axiom.getProperty()), (OWLObjectPropertyAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addTransitiveProperty(p);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addIrreflexiveProperty(p);
    }

    public void visit(OWLDataSubPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        this.kb.addSubProperty(p1, p2);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addInverseFunctionalProperty(p);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        this.kb.addInverseProperty(p1, p2);
    }

    public void visit(OWLDataRangeFacetRestriction node) {
    }

    public void visit(OWLObjectAnnotation annotation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring object annotation: " + annotation));
        }
    }

    public void visit(OWLConstantAnnotation annotation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring constant annotation: " + annotation));
        }
    }

    public void visit(SWRLRule rule) {
        if (!PelletOptions.DL_SAFE_RULES) {
            return;
        }
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        List<RuleAtom> head = this.parseAtomList(rule.getHead());
        List<RuleAtom> body = this.parseAtomList(rule.getBody());
        if (head == null || body == null) {
            this.addUnsupportedAxiom((OWLAxiom)rule);
            return;
        }
        Rule pelletRule = new Rule(head, body);
        this.kb.addRule(pelletRule);
    }

    private List<RuleAtom> parseAtomList(Set<SWRLAtom> atomList) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (SWRLAtom atom : atomList) {
            atom.accept((OWLObjectVisitor)this);
            if (this.swrlAtom == null) {
                return null;
            }
            atoms.add(this.swrlAtom);
        }
        return atoms;
    }

    public void visit(SWRLClassAtom atom) {
        OWLDescription c = (OWLDescription)atom.getPredicate();
        SWRLAtomIObject v = (SWRLAtomIObject)atom.getArgument();
        v.accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        c.accept((OWLObjectVisitor)this);
        this.swrlAtom = new ClassAtom(this.term, subj);
    }

    public void visit(SWRLDataRangeAtom atom) {
        DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
        ((OWLDataRange)atom.getPredicate()).accept((OWLObjectVisitor)this);
        Datatype datatype = dtReasoner.getDatatype(this.term);
        ((SWRLAtomDObject)atom.getArgument()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new DataRangeAtom(datatype, this.swrlDObject);
    }

    public void visit(SWRLObjectPropertyAtom atom) {
        if (((OWLObjectPropertyExpression)atom.getPredicate()).isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomIObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        ((OWLObjectPropertyExpression)atom.getPredicate()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new IndividualPropertyAtom(this.term, subj, obj);
    }

    public void visit(SWRLDataValuedPropertyAtom atom) {
        if (((OWLDataPropertyExpression)atom.getPredicate()).isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomDObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomDObject obj = this.swrlDObject;
        ((OWLDataPropertyExpression)atom.getPredicate()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new DatavaluedPropertyAtom(this.term, subj, obj);
    }

    public void visit(SWRLSameAsAtom atom) {
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomIObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        this.swrlAtom = new SameIndividualAtom(subj, obj);
    }

    public void visit(SWRLDifferentFromAtom atom) {
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomIObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        this.swrlAtom = new DifferentIndividualsAtom(subj, obj);
    }

    public void visit(SWRLBuiltInAtom atom) {
        ArrayList<AtomDObject> arguments = new ArrayList<AtomDObject>(atom.getAllArguments().size());
        for (SWRLAtomDObject swrlArg : atom.getArguments()) {
            swrlArg.accept((OWLObjectVisitor)this);
            arguments.add(this.swrlDObject);
        }
        this.swrlAtom = new BuiltInAtom(((SWRLBuiltInsVocabulary)atom.getPredicate()).getURI().toString(), arguments);
    }

    public void visit(SWRLAtomDVariable dvar) {
        this.swrlDObject = new AtomDVariable(dvar.getURI().toString());
    }

    public void visit(SWRLAtomIVariable ivar) {
        this.swrlIObject = new AtomIVariable(ivar.getURI().toString());
    }

    public void visit(SWRLAtomIndividualObject iobj) {
        iobj.getIndividual().accept((OWLObjectVisitor)this);
        this.swrlIObject = new AtomIConstant(this.term);
    }

    public void visit(SWRLAtomConstantObject cons) {
        cons.getConstant().accept((OWLObjectVisitor)this);
        this.swrlDObject = new AtomDConstant(this.term);
    }

    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

