/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.test.WebOntTest;
import org.mindswap.pellet.test.WebOntTestCase;
import org.mindswap.pellet.utils.AlphaNumericComparator;

public class LiebigTestSuite
extends TestSuite {
    public static String base = PelletTestSuite.base + "liebig-tests/";
    private static List TIMEOUTS = Arrays.asList("Manifest1b.rdf", "Manifest2b.rdf", "Manifest10a.rdf");
    private WebOntTest test = new WebOntTest();

    public LiebigTestSuite() {
        super("Liebig-Tests");
        this.test.setAvoidFailTests(true);
        this.test.setBase("http://www.informatik.uni-ulm.de/ki/Liebig/reasoner-eval/", "file:" + base);
        this.test.setShowStats(0);
        File testDir = new File(base);
        File[] files = testDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().indexOf("Manifest") != -1;
            }
        });
        Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
        for (int j = 0; j < files.length; ++j) {
            if (TIMEOUTS.contains(files[j].getName())) continue;
            this.addTest((Test)new WebOntTestCase(this.test, files[j], "liebig-" + files[j].getName()));
        }
    }

    public static TestSuite suite() {
        return new LiebigTestSuite();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LiebigTestSuite.suite());
    }
}

