/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.test.utils.TestUtils;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class IncConsistencyPerfTest {
    static double ITERS = 500.0;
    static String[] DEFAULT_FILES = new String[]{"LUBM", "http://www.mindswap.org/~chris/tmp/University0.owl", "OUBM", "http://www.mindswap.org/~chris/tmp/univ-bench-lite-3dept.owl"};

    public static void main(String[] args) throws Exception {
        String[] files = DEFAULT_FILES;
        boolean formatHTML = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-html")) {
                formatHTML = true;
                continue;
            }
            System.err.println("Unknown option " + args[i]);
        }
        for (int k = 0; k < 1; ++k) {
            List<String> cols = Arrays.asList("Name", "OWL Species", "DL Expressivity", "Triples", "Classes", "Properties", "Individuals", "Loading", "Classify", "Realize", "Initial Consistency", "Avg. Update Consistency", "Total");
            TableData table = new TableData(cols);
            for (int i = 0; i < files.length; i += 2) {
                try {
                    String name = files[i];
                    String file = files[i + 1];
                    for (int l = 1; l < 2; ++l) {
                        if (l == 1) {
                            name = name + "inc";
                        }
                        System.out.println("\nStarting test: " + name);
                        ArrayList<Object> list = new ArrayList<Object>();
                        if (formatHTML) {
                            list.add("<a href=\"" + file + "\">" + name + "</a>");
                        } else {
                            list.add(name);
                        }
                        System.gc();
                        System.gc();
                        System.gc();
                        ModelReader reader = new ModelReader();
                        Model model = reader.read(file);
                        Timer t = new Timer("timer");
                        System.out.println("  Loading reasoner");
                        OWLReasoner reasoner = new OWLReasoner();
                        t.start();
                        reasoner.load(model);
                        PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
                        PelletOptions.USE_COMPLETION_QUEUE = true;
                        reasoner.isConsistent();
                        t.stop();
                        long iCons = reasoner.getKB().timers.getTimer("consistency").getTotal();
                        reasoner.getKB().timers.getTimer("consistency").reset();
                        OWLReasoner incReasoner = new OWLReasoner();
                        t.start();
                        incReasoner.load(model);
                        incReasoner.isConsistent();
                        t.stop();
                        boolean err = false;
                        long total = 0L;
                        long largest = 0L;
                        long incTotal = 0L;
                        long incLargest = 0L;
                        boolean isIncCon = true;
                        boolean isCon = true;
                        ATermAppl ind1 = null;
                        ATermAppl ind2 = null;
                        long cons = 0L;
                        ATermAppl clazz = null;
                        ATermAppl prop = null;
                        System.out.println("  Starting test...");
                        int j = 0;
                        while ((double)j < ITERS) {
                            if (!isCon) {
                                incReasoner = new OWLReasoner();
                                incReasoner.load(model);
                                incReasoner.isConsistent();
                            }
                            Random rand = new Random(System.currentTimeMillis());
                            boolean type = rand.nextBoolean();
                            Timers timers = reasoner.getKB().timers;
                            System.out.println("Run " + j + " update type: " + type);
                            if (type) {
                                clazz = TestUtils.selectRandomConcept(incReasoner.getKB());
                                boolean neg = rand.nextBoolean();
                                if (neg) {
                                    clazz = ATermUtils.makeNot(clazz);
                                }
                                if (reasoner.getKB().getIndividuals().size() > 10) {
                                    ind1 = TestUtils.selectRandomIndividual(incReasoner.getKB());
                                } else {
                                    ind1 = IncConsistencyPerfTest.term("http://www.example#ind" + j);
                                    incReasoner.getKB().addIndividual(ind1);
                                }
                                System.out.println("  Update: Add type " + clazz + " to " + ind1.getName());
                                incReasoner.getKB().addType(ind1, clazz);
                                isCon = incReasoner.getKB().isConsistent();
                                cons = incReasoner.getKB().timers.getTimer("consistency").getLast();
                                if (cons > largest) {
                                    largest = cons;
                                }
                                total += cons;
                            } else {
                                prop = TestUtils.selectRandomObjectProperty(incReasoner.getKB());
                                if (incReasoner.getKB().getIndividuals().size() > 10) {
                                    ind1 = TestUtils.selectRandomIndividual(incReasoner.getKB());
                                    ind2 = TestUtils.selectRandomIndividual(incReasoner.getKB());
                                } else {
                                    ind1 = IncConsistencyPerfTest.term("http://www.example#ind" + j);
                                    ind2 = IncConsistencyPerfTest.term("http://www.example#indb" + j);
                                    incReasoner.getKB().addIndividual(ind1);
                                    incReasoner.getKB().addIndividual(ind2);
                                }
                                System.out.println("  Update: Add prop " + prop + " to " + ind1.getName() + " -- " + ind2.getName());
                                incReasoner.getKB().addPropertyValue(prop, ind1, ind2);
                                isCon = incReasoner.getKB().isConsistent();
                                cons = incReasoner.getKB().timers.getTimer("consistency").getLast();
                                if (cons > largest) {
                                    largest = cons;
                                }
                                total += cons;
                            }
                            System.out.println("  Consistent? " + isCon);
                            System.out.println("  Total Consistency time: " + cons + " ms");
                            ++j;
                        }
                        double avg = (double)total / ITERS;
                        double incAvg = (double)incTotal / ITERS;
                        list.add(reasoner.getSpecies().toString());
                        list.add(reasoner.getKB().getExpressivity());
                        list.add(new Long(model.size()));
                        KnowledgeBase kb = reasoner.getKB();
                        list.add(new Long(kb.getClasses().size()));
                        list.add(new Long(kb.getProperties().size()));
                        list.add(new Long(kb.getIndividuals().size()));
                        Timers timers = reasoner.getKB().timers;
                        list.add(new Double((double)(timers.getTimer("Loading").getTotal() + timers.getTimer("preprocessing").getTotal()) / 1000.0));
                        list.add(0);
                        list.add(0);
                        list.add(new Double(iCons));
                        list.add(new Double(avg));
                        list.add(new Double(t.getTotal()));
                        table.add(list);
                    }
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            System.out.println();
            table.print(System.out, formatHTML);
        }
    }

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }
}

