/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.pure.PureFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.MultiIterator;
import org.mindswap.pellet.utils.MultiListIterator;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATermUtils {
    public static final String NOT = "not";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String SOME = "some";
    public static final String ALL = "all";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String CARD = "card";
    public static final String VALUE = "value";
    public static final String SELF = "self";
    public static final String INV = "inv";
    public static final String SUB = "sub";
    public static final String SAME = "same";
    public static final String DISJOINT = "disjoint";
    public static final String DISJOINTS = "disjoints";
    public static final String COMPLEMENT = "complement";
    private static final ATermFactory factory = new PureFactory();
    public static final AFun LITFUN = factory.makeAFun("literal", 3, false);
    public static final int LIT_VAL_INDEX = 0;
    public static final int LIT_LANG_INDEX = 1;
    public static final int LIT_URI_INDEX = 2;
    public static final AFun ANDFUN = factory.makeAFun("and", 1, false);
    public static final AFun ORFUN = factory.makeAFun("or", 1, false);
    public static final AFun SOMEFUN = factory.makeAFun("some", 2, false);
    public static final AFun ALLFUN = factory.makeAFun("all", 2, false);
    public static final AFun NOTFUN = factory.makeAFun("not", 1, false);
    public static final AFun MAXFUN = factory.makeAFun("max", 3, false);
    public static final AFun MINFUN = factory.makeAFun("min", 3, false);
    public static final AFun VALUEFUN = factory.makeAFun("value", 1, false);
    public static final AFun SELFFUN = factory.makeAFun("self", 1, false);
    public static final AFun CARDFUN = factory.makeAFun("card", 3, false);
    public static Set CLASS_FUN = SetUtils.create(new AFun[]{ALLFUN, SOMEFUN, MAXFUN, MINFUN, CARDFUN, ANDFUN, ORFUN, NOTFUN, VALUEFUN, SELFFUN});
    public static final AFun INVFUN = factory.makeAFun("inv", 1, false);
    public static final AFun SUBFUN = factory.makeAFun("subClassOf", 2, false);
    public static final AFun EQCLASSFUN = factory.makeAFun("equivalentClasses", 2, false);
    public static final AFun SAMEASFUN = factory.makeAFun("sameAs", 2, false);
    public static final AFun DISJOINTFUN = factory.makeAFun("disjointWith", 2, false);
    public static final AFun DISJOINTSFUN = factory.makeAFun("disjointClasses", 1, false);
    public static final AFun COMPLEMENTFUN = factory.makeAFun("complementOf", 2, false);
    public static final AFun VARFUN = factory.makeAFun("var", 1, false);
    public static final AFun TYPEFUN = factory.makeAFun("type", 2, false);
    public static final AFun PROPFUN = factory.makeAFun("prop", 3, false);
    public static final AFun IPFUN = factory.makeAFun("iptriple", 3, false);
    public static final AFun DPFUN = factory.makeAFun("dptriple", 3, false);
    public static final AFun DIFFERENTFUN = factory.makeAFun("different", 2, false);
    public static final AFun ALLDIFFERENTFUN = factory.makeAFun("allDifferent", 1, false);
    public static final AFun ANTISYMMETRICFUN = factory.makeAFun("antisymmetric", 1, false);
    public static final AFun FUNCTIONALFUN = factory.makeAFun("functional", 1, false);
    public static final AFun INVFUNCTIONALFUN = factory.makeAFun("inverseFunctional", 1, false);
    public static final AFun IRREFLEXIVEFUN = factory.makeAFun("irreflexive", 1, false);
    public static final AFun REFLEXIVEFUN = factory.makeAFun("reflexive", 1, false);
    public static final AFun SYMMETRICFUN = factory.makeAFun("symmetric", 1, false);
    public static final AFun TRANSITIVEFUN = factory.makeAFun("transitive", 1, false);
    public static final AFun SUBPROPFUN = factory.makeAFun("subProperty", 2, false);
    public static final AFun EQPROPFUN = factory.makeAFun("equivalentProperty", 2, false);
    public static final AFun INVPROPFUN = factory.makeAFun("inverseProperty", 2, false);
    public static final AFun DOMAINFUN = factory.makeAFun("domain", 2, false);
    public static final AFun RANGEFUN = factory.makeAFun("range", 2, false);
    public static final ATermAppl EMPTY = ATermUtils.makeTermAppl("");
    public static final ATermList EMPTY_LIST = factory.makeList();
    public static final ATermAppl TOP = ATermUtils.makeTermAppl("_TOP_");
    public static final ATermAppl BOTTOM = ATermUtils.makeNot(TOP);
    public static final ATermAppl TOP_LIT = ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal");
    public static final ATermAppl BOTTOM_LIT = ATermUtils.makeNot(TOP_LIT);
    public static final ATermAppl CONCEPT_SAT_IND = ATermUtils.makeTermAppl("_C_");
    public static final ATermInt ONE = factory.makeInt(1);
    public static QNameProvider qnames = new QNameProvider();
    public static ATermAppl NO_DATATYPE = ATermUtils.makeTermAppl("NO_DATATYPE");
    private static AFun ANON_NOMINAL_FUN = factory.makeAFun("anon_nominal", 1, false);

    public static ATermFactory getFactory() {
        return factory;
    }

    public static final ATermAppl makeTypeAtom(ATermAppl ind, ATermAppl c) {
        return factory.makeAppl(TYPEFUN, ind, c);
    }

    public static final ATermAppl makePropAtom(ATermAppl p, ATermAppl s, ATermAppl o) {
        return factory.makeAppl(PROPFUN, p, s, o);
    }

    public static ATermAppl makePlainLiteral(String value) {
        return factory.makeAppl(LITFUN, ATermUtils.makeTermAppl(value), EMPTY, EMPTY);
    }

    public static ATermAppl makePlainLiteral(String value, String lang) {
        return factory.makeAppl(LITFUN, ATermUtils.makeTermAppl(value), ATermUtils.makeTermAppl(lang), EMPTY);
    }

    public static ATermAppl makeTypedLiteral(String value, String dt) {
        return factory.makeAppl(LITFUN, ATermUtils.makeTermAppl(value), EMPTY, ATermUtils.makeTermAppl(dt));
    }

    public static ATermAppl makeLiteral(ATermAppl name) {
        return factory.makeAppl(LITFUN, name, EMPTY, NO_DATATYPE);
    }

    public static String getLiteralValue(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(0)).getName();
    }

    public static String getLiteralLang(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(1)).getName();
    }

    public static String getLiteralDatatype(ATermAppl literal) {
        return ((ATermAppl)literal.getArgument(2)).getName();
    }

    public static ATermAppl makeTermAppl(String name) {
        return factory.makeAppl(factory.makeAFun(name, 0, false));
    }

    public static ATermAppl makeTermAppl(AFun fun, ATerm[] args) {
        return factory.makeAppl(fun, args);
    }

    public static ATermAppl makeNot(ATerm c) {
        return factory.makeAppl(NOTFUN, c);
    }

    public static ATerm term(String str) {
        return factory.parse(str);
    }

    public static ATermAppl term(URI u) {
        if (PelletOptions.USE_LOCAL_NAME) {
            String localName = u.getFragment();
            if (localName == null) {
                localName = URIUtils.getLocalName(u.toString());
            }
            return ATermUtils.makeTermAppl(localName);
        }
        if (PelletOptions.USE_QNAME) {
            return ATermUtils.makeTermAppl(qnames.shortForm(u));
        }
        return ATermUtils.makeTermAppl(u.toString());
    }

    public static ATermList negate(ATermList list) {
        if (list.isEmpty()) {
            return list;
        }
        ATermAppl a = (ATermAppl)list.getFirst();
        a = ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot(a);
        ATermList result = ATermUtils.makeList(a, ATermUtils.negate(list.getNext()));
        return result;
    }

    public static final ATermAppl negate(ATermAppl a) {
        return ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot(a);
    }

    public static final boolean isAnonNominal(ATermAppl term) {
        return term.getAFun().equals(ANON_NOMINAL_FUN);
    }

    public static final ATermAppl makeAnonNominal(String name) {
        return factory.makeAppl(ANON_NOMINAL_FUN, ATermUtils.makeTermAppl(name));
    }

    public static final ATermAppl makeVar(String name) {
        return factory.makeAppl(VARFUN, ATermUtils.makeTermAppl(name));
    }

    public static final ATermAppl makeVar(ATermAppl name) {
        return factory.makeAppl(VARFUN, name);
    }

    public static final ATermAppl makeValue(ATerm c) {
        return factory.makeAppl(VALUEFUN, c);
    }

    public static final ATermAppl makeInv(ATermAppl r) {
        if (ATermUtils.isInv(r)) {
            return (ATermAppl)r.getArgument(0);
        }
        return factory.makeAppl(INVFUN, r);
    }

    public static final ATermAppl makeInvProp(ATerm r, ATerm s) {
        return factory.makeAppl(INVPROPFUN, r, s);
    }

    public static final ATermAppl makeSub(ATerm a, ATerm b) {
        return factory.makeAppl(SUBFUN, a, b);
    }

    public static final ATermAppl makeSame(ATerm a, ATerm b) {
        return ATermUtils.makeEqClasses(a, b);
    }

    public static final ATermAppl makeEqClasses(ATerm a, ATerm b) {
        return factory.makeAppl(EQCLASSFUN, a, b);
    }

    public static final ATermAppl makeSameAs(ATerm a, ATerm b) {
        return factory.makeAppl(SAMEASFUN, a, b);
    }

    public static final ATermAppl makeSubProp(ATerm r, ATerm s) {
        return factory.makeAppl(SUBPROPFUN, r, s);
    }

    public static final ATermAppl makeEqProp(ATerm r, ATerm s) {
        return factory.makeAppl(EQPROPFUN, r, s);
    }

    public static final ATermAppl makeDomain(ATerm r, ATerm c) {
        return factory.makeAppl(DOMAINFUN, r, c);
    }

    public static final ATermAppl makeRange(ATerm r, ATerm c) {
        return factory.makeAppl(RANGEFUN, r, c);
    }

    public static final ATermAppl makeComplement(ATerm a, ATerm b) {
        return factory.makeAppl(COMPLEMENTFUN, a, b);
    }

    public static final ATermAppl makeDisjoint(ATerm a, ATerm b) {
        return factory.makeAppl(DISJOINTFUN, a, b);
    }

    public static final ATermAppl makeDisjoints(ATermList list) {
        return factory.makeAppl(DISJOINTSFUN, list);
    }

    public static final ATermAppl makeDifferent(ATerm a, ATerm b) {
        return factory.makeAppl(DIFFERENTFUN, a, b);
    }

    public static final ATermAppl makeAllDifferent(ATermList list) {
        return factory.makeAppl(ALLDIFFERENTFUN, list);
    }

    public static final ATermAppl makeAntisymmetric(ATerm r) {
        return factory.makeAppl(ANTISYMMETRICFUN, r);
    }

    public static final ATermAppl makeFunctional(ATerm a) {
        return factory.makeAppl(FUNCTIONALFUN, a);
    }

    public static final ATermAppl makeInverseFunctional(ATerm a) {
        return factory.makeAppl(INVFUNCTIONALFUN, a);
    }

    public static final ATermAppl makeIrreflexive(ATerm r) {
        return factory.makeAppl(IRREFLEXIVEFUN, r);
    }

    public static final ATermAppl makeReflexive(ATerm r) {
        return factory.makeAppl(REFLEXIVEFUN, r);
    }

    public static final ATermAppl makeSymmetric(ATerm r) {
        return factory.makeAppl(SYMMETRICFUN, r);
    }

    public static final ATermAppl makeTransitive(ATerm r) {
        return factory.makeAppl(TRANSITIVEFUN, r);
    }

    public static final ATermAppl makeAnd(ATerm c1, ATerm c2) {
        return ATermUtils.makeAnd(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATermAppl makeAnd(ATermList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return TOP;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ANDFUN, list);
    }

    public static final ATermAppl makeOr(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATermAppl makeOr(ATermList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ORFUN, list);
    }

    public static final ATermAppl makeAllValues(ATerm r, ATerm c) {
        ATermList list;
        if (r.getType() == 4 && (list = (ATermList)r).getLength() == 1) {
            r = list.getFirst();
        }
        return factory.makeAppl(ALLFUN, r, c);
    }

    public static final ATermAppl makeSomeValues(ATerm r, ATerm c) {
        ATermUtils.assertTrue(c instanceof ATermAppl);
        return factory.makeAppl(SOMEFUN, r, c);
    }

    public static final ATermAppl makeSelf(ATermAppl r) {
        return factory.makeAppl(SELFFUN, r);
    }

    public static final ATermAppl makeHasValue(ATerm r, ATerm ind) {
        ATermAppl c = ATermUtils.makeValue(ind);
        return factory.makeAppl(SOMEFUN, r, c);
    }

    public static final ATermAppl makeNormalizedMax(ATermAppl r, int n, ATermAppl c) {
        ATermUtils.assertTrue(n >= 0);
        return ATermUtils.makeNot(ATermUtils.makeMin((ATerm)r, n + 1, (ATerm)ATermUtils.negate(c)));
    }

    public static final ATermAppl makeMax(ATerm r, int n, ATerm c) {
        return ATermUtils.makeMax(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeMax(ATerm r, ATermInt n, ATerm c) {
        ATermUtils.assertTrue(n.getInt() >= 0);
        return factory.makeAppl(MAXFUN, r, n, c);
    }

    public static final ATermAppl makeMin(ATerm r, int n, ATerm c) {
        return ATermUtils.makeMin(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeMin(ATerm r, ATermInt n, ATerm c) {
        ATermUtils.assertTrue(n.getInt() >= 0);
        return factory.makeAppl(MINFUN, r, n, c);
    }

    public static final ATermAppl makeDisplayCard(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(CARDFUN, r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeDisplayMax(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MAXFUN, r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeDisplayMin(ATerm r, int n, ATerm c) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MINFUN, r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeCard(ATerm r, int n, ATerm c) {
        return ATermUtils.makeDisplayCard(r, n, c);
    }

    public static final ATermAppl makeExactCard(ATerm r, int n, ATerm c) {
        return ATermUtils.makeExactCard(r, factory.makeInt(n), c);
    }

    public static final ATermAppl makeExactCard(ATerm r, ATermInt n, ATerm c) {
        ATermAppl max = ATermUtils.makeMax(r, n, c);
        if (n.getInt() == 0) {
            return max;
        }
        ATermAppl min = ATermUtils.makeMin(r, n, c);
        return ATermUtils.makeAnd(min, max);
    }

    public static final ATermList makeList(ATerm singleton) {
        return factory.makeList(singleton, EMPTY_LIST);
    }

    public static final ATermList makeList(ATerm first, ATermList rest) {
        return factory.makeList(first, rest);
    }

    public static ATermList makeList(Collection set) {
        ATermList list = EMPTY_LIST;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            list = list.insert((ATerm)iter.next());
        }
        return list;
    }

    public static final ATermList makeList(ATerm[] aTerms) {
        return ATermUtils.makeList(aTerms, 0);
    }

    private static ATermList makeList(ATerm[] aTerms, int index) {
        if (index >= aTerms.length) {
            return EMPTY_LIST;
        }
        if (index == aTerms.length - 1) {
            return ATermUtils.makeList(aTerms[index]);
        }
        return ATermUtils.makeList(aTerms[index], ATermUtils.makeList(aTerms, index + 1));
    }

    public static final boolean member(ATerm a, ATermList list) {
        return list.indexOf(a, 0) != -1;
    }

    public static boolean isSet(ATermList list) {
        if (list.isEmpty()) {
            return true;
        }
        ATerm curr = list.getFirst();
        list = list.getNext();
        while (!list.isEmpty()) {
            ATerm next = list.getFirst();
            if (Comparators.hashCodeComparator.compare(curr, next) >= 0) {
                return false;
            }
            curr = next;
            list = list.getNext();
        }
        return true;
    }

    public static ATermList toSet(ATermList list) {
        if (ATermUtils.isSet(list)) {
            return list;
        }
        int size = list.getLength();
        ATerm[] a = ATermUtils.toArray(list);
        if (a == null || a.length < size) {
            a = new ATerm[Math.max(100, size)];
        }
        Arrays.sort(a, 0, size, Comparators.hashCodeComparator);
        ATermList set = ATermUtils.makeList(a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = set.getFirst();
            if (((Object)s).equals(a[i])) continue;
            set = set.insert(a[i]);
        }
        return set;
    }

    public static ATermList toSet(ATerm[] a, int size) {
        Arrays.sort(a, 0, size, Comparators.hashCodeComparator);
        ATermList set = ATermUtils.makeList(a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = set.getFirst();
            if (((Object)s).equals(a[i])) continue;
            set = set.insert(a[i]);
        }
        return set;
    }

    public static ATermList toSet(Collection coll) {
        int size = coll.size();
        ATerm[] a = new ATermAppl[size];
        coll.toArray(a);
        return ATermUtils.toSet(a, size);
    }

    public static String toString(ATermAppl term) {
        if (ATermUtils.isVar(term)) {
            return "?" + ((ATermAppl)term.getArgument(0)).getName();
        }
        if (ATermUtils.isLiteral(term)) {
            String value = ((ATermAppl)term.getArgument(0)).getName();
            String lang = ((ATermAppl)term.getArgument(1)).getName();
            String datatypeURI = ((ATermAppl)term.getArgument(2)).getName();
            StringBuffer sb = new StringBuffer();
            sb.append('\"').append(value).append('\"');
            if (!lang.equals("")) {
                sb.append('@').append(lang);
            } else if (!datatypeURI.equals("")) {
                sb.append("^^").append(datatypeURI);
            }
            return sb.toString();
        }
        return term.getName();
    }

    public static ATerm[] toArray(ATermList list) {
        ATerm[] a = new ATerm[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            a[i++] = list.getFirst();
            list = list.getNext();
        }
        return a;
    }

    public static final void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public static final boolean isPrimitive(ATermAppl c) {
        return c.getArity() == 0;
    }

    public static final boolean isNegatedPrimitive(ATermAppl c) {
        return ATermUtils.isNot(c) && ATermUtils.isPrimitive((ATermAppl)c.getArgument(0));
    }

    public static final boolean isPrimitiveOrNegated(ATermAppl c) {
        return ATermUtils.isPrimitive(c) || ATermUtils.isNegatedPrimitive(c);
    }

    public static final boolean isBnode(ATermAppl name) {
        return name.getName().startsWith("bNode");
    }

    public static final boolean isAnon(ATermAppl name) {
        return name.getName().startsWith("anon");
    }

    public static Set listToSet(ATermList list) {
        HashSet<ATerm> set = new HashSet<ATerm>();
        while (!list.isEmpty()) {
            set.add(list.getFirst());
            list = list.getNext();
        }
        return set;
    }

    public static Set<ATermAppl> getPrimitives(ATermList list) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (ATermUtils.isPrimitive(term)) {
                set.add(term);
            }
            list = list.getNext();
        }
        return set;
    }

    public static final ATermAppl getTop(Role r) {
        return r.isDatatypeRole() ? TOP_LIT : TOP;
    }

    public static final boolean isTop(ATermAppl a) {
        return a.equals(TOP) || a.equals(TOP_LIT);
    }

    public static final boolean isBottom(ATermAppl a) {
        return a.equals(BOTTOM) || a.equals(BOTTOM_LIT);
    }

    public static final boolean isInv(ATermAppl r) {
        return r.getAFun().equals(INVFUN);
    }

    public static final boolean isAnd(ATermAppl a) {
        return a.getAFun().equals(ANDFUN);
    }

    public static final boolean isOr(ATermAppl a) {
        return a.getAFun().equals(ORFUN);
    }

    public static final boolean isAllValues(ATermAppl a) {
        return a.getAFun().equals(ALLFUN);
    }

    public static final boolean isSomeValues(ATermAppl a) {
        return a.getAFun().equals(SOMEFUN);
    }

    public static final boolean isSelf(ATermAppl a) {
        return a.getAFun().equals(SELFFUN);
    }

    public static final boolean isHasValue(ATermAppl a) {
        return a.getAFun().equals(SOMEFUN) && ((ATermAppl)a.getArgument(1)).getAFun().equals(VALUEFUN);
    }

    public static final boolean isNominal(ATermAppl a) {
        return a.getAFun().equals(VALUEFUN);
    }

    public static final boolean isOneOf(ATermAppl a) {
        if (!a.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            if (!ATermUtils.isNominal((ATermAppl)list.getFirst())) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isDataRange(ATermAppl a) {
        if (!a.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (!ATermUtils.isNominal(term) || !ATermUtils.isLiteral((ATermAppl)term.getArgument(0))) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isNot(ATermAppl a) {
        return a.getAFun().equals(NOTFUN);
    }

    public static final boolean isMax(ATermAppl a) {
        return a.getAFun().equals(MAXFUN);
    }

    public static final boolean isMin(ATermAppl a) {
        return a.getAFun().equals(MINFUN);
    }

    public static final boolean isCard(ATermAppl a) {
        if (ATermUtils.isMin(a) || ATermUtils.isMax(a)) {
            return true;
        }
        if (ATermUtils.isAnd(a)) {
            return ATermUtils.isMin(a = (ATermAppl)a.getArgument(0)) || ATermUtils.isMax(a);
        }
        return false;
    }

    public static final boolean isLiteral(ATermAppl a) {
        return a.getAFun().equals(LITFUN);
    }

    public static final boolean isVar(ATermAppl a) {
        return a.getAFun().equals(VARFUN);
    }

    public static final boolean isTransitiveChain(ATermList chain, ATerm r) {
        return chain.getLength() == 2 && ((Object)chain.getFirst()).equals(r) && ((Object)chain.getLast()).equals(r);
    }

    public static boolean isComplexClass(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            AFun f = a.getAFun();
            return CLASS_FUN.contains(f);
        }
        return false;
    }

    public static final boolean isPropertyAssertion(ATermAppl a) {
        return a.getAFun().equals(PROPFUN);
    }

    public static final boolean isTypeAssertion(ATermAppl a) {
        return a.getAFun().equals(TYPEFUN);
    }

    public static ATerm nnf(ATerm term) {
        if (term instanceof ATermList) {
            return ATermUtils.nnf((ATermList)term);
        }
        if (term instanceof ATermAppl) {
            return ATermUtils.nnf((ATermAppl)term);
        }
        return null;
    }

    public static ATermList nnf(ATermList list) {
        ATermList newList = factory.makeList();
        while (!list.isEmpty()) {
            newList = newList.append(ATermUtils.nnf((ATermAppl)list.getFirst()));
            list = list.getNext();
        }
        return newList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ATermAppl nnf(ATermAppl term) {
        ATermAppl newterm = null;
        AFun af = term.getAFun();
        if (af.equals(NOTFUN)) {
            ATermUtils.assertTrue(af.getArity() == 1);
            ATermAppl arg = (ATermAppl)term.getArgument(0);
            af = arg.getAFun();
            if (arg.getArity() == 0) {
                newterm = term;
            } else if (af.equals(NOTFUN)) {
                newterm = ATermUtils.nnf((ATermAppl)arg.getArgument(0));
            } else if (af.equals(VALUEFUN) || af.equals(SELFFUN)) {
                newterm = term;
            } else if (af.equals(MAXFUN)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = ATermUtils.makeMin(arg.getArgument(0), n.getInt() + 1, ATermUtils.nnf(arg.getArgument(2)));
            } else if (af.equals(MINFUN)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = n.getInt() == 0 ? BOTTOM : ATermUtils.makeMax(arg.getArgument(0), n.getInt() - 1, ATermUtils.nnf(arg.getArgument(2)));
            } else if (af.equals(CARDFUN)) {
                newterm = ATermUtils.nnf(ATermUtils.makeNot(ATermUtils.makeExactCard(arg.getArgument(0), (ATermInt)arg.getArgument(1), arg.getArgument(2))));
            } else if (af.equals(ANDFUN)) {
                newterm = ATermUtils.makeOr(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
            } else if (af.equals(ORFUN)) {
                newterm = ATermUtils.makeAnd(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
            } else if (af.equals(SOMEFUN)) {
                ATerm p = arg.getArgument(0);
                ATerm c = arg.getArgument(1);
                newterm = ATermUtils.makeAllValues(p, ATermUtils.nnf(ATermUtils.makeNot(c)));
            } else {
                if (!af.equals(ALLFUN)) throw new InternalReasonerException("Unknown term type: " + term);
                ATerm p = arg.getArgument(0);
                ATerm c = arg.getArgument(1);
                newterm = ATermUtils.makeSomeValues(p, ATermUtils.nnf(ATermUtils.makeNot(c)));
            }
        } else if (af.equals(MINFUN) || af.equals(MAXFUN) || af.equals(SELFFUN)) {
            newterm = term;
        } else if (af.equals(CARDFUN)) {
            newterm = ATermUtils.nnf(ATermUtils.makeExactCard(term.getArgument(0), (ATermInt)term.getArgument(1), term.getArgument(2)));
        } else {
            ATerm[] args = new ATerm[term.getArity()];
            for (int i = 0; i < term.getArity(); ++i) {
                args[i] = ATermUtils.nnf(term.getArgument(i));
            }
            newterm = factory.makeAppl(af, args);
        }
        ATermUtils.assertTrue(newterm != null);
        return newterm;
    }

    public static Collection<ATermAppl> normalize(Collection<ATermAppl> coll) {
        ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
        for (ATermAppl term : coll) {
            list.add(ATermUtils.normalize(term));
        }
        return list;
    }

    public static ATermList normalize(ATermList list) {
        int size = list.getLength();
        ATerm[] terms = new ATerm[size];
        for (int i = 0; i < size; ++i) {
            terms[i] = ATermUtils.normalize((ATermAppl)list.getFirst());
            list = list.getNext();
        }
        ATermList set = ATermUtils.toSet(terms, size);
        return set;
    }

    public static ATermAppl normalize(ATermAppl term) {
        ATerm arg3;
        ATermAppl norm = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        ATerm aTerm = arg3 = term.getArity() > 2 ? term.getArgument(2) : null;
        if (!(arg1 == null || fun.equals(SELFFUN) || fun.equals(VALUEFUN) || fun.equals(INVFUN))) {
            if (fun.equals(NOTFUN)) {
                if (!ATermUtils.isPrimitive((ATermAppl)arg1)) {
                    norm = ATermUtils.simplify(ATermUtils.makeNot(ATermUtils.normalize((ATermAppl)arg1)));
                }
            } else if (fun.equals(ANDFUN)) {
                norm = ATermUtils.simplify(ATermUtils.makeAnd(ATermUtils.normalize((ATermList)arg1)));
            } else if (fun.equals(ORFUN)) {
                ATermList neg = ATermUtils.negate((ATermList)arg1);
                ATermAppl and = ATermUtils.makeAnd(neg);
                ATermAppl notAnd = ATermUtils.makeNot(and);
                norm = ATermUtils.normalize(notAnd);
            } else if (fun.equals(ALLFUN)) {
                norm = ATermUtils.simplify(ATermUtils.makeAllValues(arg1, ATermUtils.normalize((ATermAppl)arg2)));
            } else if (fun.equals(SOMEFUN)) {
                norm = ATermUtils.normalize(ATermUtils.makeNot(ATermUtils.makeAllValues(arg1, ATermUtils.makeNot(arg2))));
            } else if (fun.equals(MAXFUN)) {
                norm = ATermUtils.normalize(ATermUtils.makeNot(ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt() + 1, arg3)));
            } else if (fun.equals(MINFUN)) {
                norm = ATermUtils.simplify(ATermUtils.makeMin(arg1, (ATermInt)arg2, (ATerm)ATermUtils.normalize((ATermAppl)arg3)));
            } else if (fun.equals(CARDFUN)) {
                ATermAppl normMin = ATermUtils.simplify(ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt(), (ATerm)ATermUtils.normalize((ATermAppl)arg3)));
                ATermAppl normMax = ATermUtils.normalize(ATermUtils.makeMax(arg1, ((ATermInt)arg2).getInt(), arg3));
                norm = ATermUtils.simplify(ATermUtils.makeAnd(normMin, normMax));
            } else {
                throw new InternalReasonerException("Unknown concept type: " + term);
            }
        }
        return norm;
    }

    public static ATermAppl simplify(ATermAppl term) {
        ATerm arg3;
        ATermAppl simp = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        ATerm aTerm = arg3 = term.getArity() > 2 ? term.getArgument(2) : null;
        if (arg1 != null && !fun.equals(SELFFUN) && !fun.equals(VALUEFUN)) {
            if (fun.equals(NOTFUN)) {
                ATermInt n;
                ATermAppl arg = (ATermAppl)arg1;
                if (ATermUtils.isNot(arg)) {
                    simp = ATermUtils.simplify((ATermAppl)arg.getArgument(0));
                } else if (ATermUtils.isMin(arg) && (n = (ATermInt)arg.getArgument(1)).getInt() == 0) {
                    simp = BOTTOM;
                }
            } else if (fun.equals(ANDFUN)) {
                ATermList conjuncts = (ATermList)arg1;
                if (conjuncts.isEmpty()) {
                    simp = TOP;
                } else {
                    HashSet<ATermAppl> set = new HashSet<ATermAppl>();
                    ArrayList<ATermAppl> negations = new ArrayList<ATermAppl>();
                    MultiListIterator i = new MultiListIterator(conjuncts);
                    while (i.hasNext()) {
                        ATermAppl c = (ATermAppl)i.next();
                        if (c.equals(TOP)) continue;
                        if (c.equals(BOTTOM)) {
                            return BOTTOM;
                        }
                        if (ATermUtils.isAnd(c)) {
                            i.append((ATermList)c.getArgument(0));
                            continue;
                        }
                        if (ATermUtils.isNot(c)) {
                            negations.add(c);
                            continue;
                        }
                        set.add(c);
                    }
                    for (ATermAppl notC : negations) {
                        ATermAppl c = (ATermAppl)notC.getArgument(0);
                        if (!set.contains(c)) continue;
                        return BOTTOM;
                    }
                    if (set.isEmpty()) {
                        if (negations.isEmpty()) {
                            return TOP;
                        }
                        if (negations.size() == 1) {
                            return (ATermAppl)negations.get(0);
                        }
                    } else if (set.size() == 1 && negations.isEmpty()) {
                        return (ATermAppl)set.iterator().next();
                    }
                    negations.addAll(set);
                    int size = negations.size();
                    ATerm[] terms = new ATermAppl[size];
                    negations.toArray(terms);
                    simp = ATermUtils.makeAnd(ATermUtils.toSet(terms, size));
                }
            } else if (fun.equals(ALLFUN)) {
                if (((Object)arg2).equals(TOP)) {
                    simp = TOP;
                }
            } else if (fun.equals(MINFUN)) {
                ATermInt n = (ATermInt)arg2;
                if (n.getInt() == 0) {
                    simp = TOP;
                }
                if (((Object)arg3).equals(BOTTOM)) {
                    simp = BOTTOM;
                }
            } else if (fun.equals(MAXFUN)) {
                ATermInt n = (ATermInt)arg2;
                if (n.getInt() > 0 && ((Object)arg3).equals(BOTTOM)) {
                    simp = TOP;
                }
            } else {
                throw new InternalReasonerException("Unknown term type: " + term);
            }
        }
        return simp;
    }

    public static ATermAppl makeSimplifiedAnd(Collection conjuncts) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> negations = new ArrayList<ATermAppl>();
        MultiListIterator listIt = new MultiListIterator(EMPTY_LIST);
        MultiIterator i = new MultiIterator(conjuncts.iterator(), listIt);
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (c.equals(TOP)) continue;
            if (c.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (ATermUtils.isAnd(c)) {
                listIt.append((ATermList)c.getArgument(0));
                continue;
            }
            if (ATermUtils.isNot(c)) {
                negations.add(c);
                continue;
            }
            set.add(c);
        }
        for (ATermAppl notC : negations) {
            ATermAppl c = (ATermAppl)notC.getArgument(0);
            if (!set.contains(c)) continue;
            return BOTTOM;
        }
        if (set.isEmpty()) {
            if (negations.isEmpty()) {
                return TOP;
            }
            if (negations.size() == 1) {
                return (ATermAppl)negations.get(0);
            }
        } else if (set.size() == 1 && negations.isEmpty()) {
            return (ATermAppl)set.iterator().next();
        }
        negations.addAll(set);
        int size = negations.size();
        ATerm[] terms = new ATermAppl[size];
        negations.toArray(terms);
        return ATermUtils.makeAnd(ATermUtils.toSet(terms, size));
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl term) {
        HashSet<ATermAppl> primitives = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(term, primitives, false, false);
        return primitives;
    }

    public static Set<ATermAppl> findPrimitives(ATermAppl term, boolean skipRestrictions, boolean skipTopLevel) {
        HashSet<ATermAppl> primitives = new HashSet<ATermAppl>();
        ATermUtils.findPrimitives(term, primitives, skipRestrictions, skipTopLevel);
        return primitives;
    }

    public static void findPrimitives(ATermAppl term, Set<ATermAppl> primitives, boolean skipRestrictions, boolean skipTopLevel) {
        AFun fun = term.getAFun();
        if (ATermUtils.isPrimitive(term)) {
            primitives.add(term);
        } else if (!fun.equals(SELFFUN) && !fun.equals(VALUEFUN)) {
            if (fun.equals(NOTFUN)) {
                ATermAppl arg = (ATermAppl)term.getArgument(0);
                if (!ATermUtils.isPrimitive(arg) || !skipTopLevel) {
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                }
            } else if (fun.equals(ANDFUN) || fun.equals(ORFUN)) {
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl arg = (ATermAppl)list.getFirst();
                    if (!ATermUtils.isNegatedPrimitive(arg) || !skipTopLevel) {
                        ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                    }
                    list = list.getNext();
                }
            } else if (!skipRestrictions) {
                if (fun.equals(ALLFUN) || fun.equals(SOMEFUN)) {
                    ATermAppl arg = (ATermAppl)term.getArgument(1);
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                } else if (fun.equals(MAXFUN) || fun.equals(MINFUN) || fun.equals(CARDFUN)) {
                    ATermAppl arg = (ATermAppl)term.getArgument(2);
                    ATermUtils.findPrimitives(arg, primitives, skipRestrictions, false);
                } else {
                    throw new InternalReasonerException("Unknown concept type: " + term);
                }
            }
        }
    }
}

