/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiIterator;

public class CandidateSet {
    private Set knowns;
    private Set unknowns;

    public CandidateSet() {
        this.knowns = new HashSet();
        this.unknowns = new HashSet();
    }

    public CandidateSet(Set knowns) {
        this.knowns = new HashSet(knowns);
        this.unknowns = new HashSet();
    }

    public CandidateSet(Set knowns, Set unknowns) {
        this.knowns = new HashSet(knowns);
        this.unknowns = new HashSet(unknowns);
    }

    public Set getKnowns() {
        return this.knowns;
    }

    public Set getUnknowns() {
        return this.unknowns;
    }

    public void add(Object obj, Bool isKnown) {
        if (isKnown.isTrue()) {
            this.knowns.add(obj);
        } else if (isKnown.isUnknown()) {
            this.unknowns.add(obj);
        }
    }

    public void update(Object obj, Bool isCandidate) {
        if (!isCandidate.isTrue()) {
            if (isCandidate.isFalse()) {
                this.remove(obj);
            } else if (this.knowns.contains(obj)) {
                this.knowns.remove(obj);
                this.unknowns.add(obj);
            }
        }
    }

    public boolean remove(Object obj) {
        return this.knowns.remove(obj) || this.unknowns.remove(obj);
    }

    public boolean contains(Object obj) {
        return this.knowns.contains(obj) || this.unknowns.contains(obj);
    }

    public int size() {
        return this.knowns.size() + this.unknowns.size();
    }

    public Iterator iterator() {
        return new MultiIterator(this.knowns.iterator(), this.unknowns.iterator());
    }

    public String toString() {
        return "Knowns: " + this.knowns.size() + " Unknowns: " + this.unknowns.size();
    }
}

