/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdf.turtle;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.coode.owl.rdf.model.RDFLiteralNode;
import org.coode.owl.rdf.model.RDFNode;
import org.coode.owl.rdf.model.RDFResourceNode;
import org.coode.owl.rdf.model.RDFTriple;
import org.coode.owl.rdf.rdfxml.RDFXMLNamespaceManager;
import org.coode.owl.rdf.renderer.RDFRendererBase;
import org.coode.xml.OWLOntologyNamespaceManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class TurtleRenderer
extends RDFRendererBase {
    private PrintWriter writer;
    private Set<RDFResourceNode> pending;
    private OWLOntologyNamespaceManager nsm;
    private String base;
    int bufferLength = 0;
    int lastNewLineIndex = 0;
    Stack<Integer> tabs = new Stack();

    public TurtleRenderer(OWLOntology ontology, OWLOntologyManager manager, Writer writer) {
        super(ontology, manager);
        this.writer = new PrintWriter(writer);
        this.pending = new HashSet<RDFResourceNode>();
        this.nsm = new RDFXMLNamespaceManager(manager, this.getOntology());
        this.base = "";
    }

    private void writeNamespaces() {
        this.write("@prefix : ");
        this.writeAsURI(this.nsm.getDefaultNamespace());
        this.write(" .");
        this.writeNewLine();
        for (String prefix : this.nsm.getPrefixes()) {
            String ns = this.nsm.getNamespaceForPrefix(prefix);
            this.write("@prefix ");
            this.write(prefix);
            this.write(": ");
            this.writeAsURI(ns);
            this.write(" .");
            this.writeNewLine();
        }
    }

    public void pushTab() {
        this.tabs.push(this.getIndent());
    }

    public void popTab() {
        if (!this.tabs.isEmpty()) {
            this.tabs.pop();
        }
    }

    private void write(String s) {
        int newLineIndex = s.indexOf(10);
        if (newLineIndex != -1) {
            this.lastNewLineIndex = this.bufferLength + newLineIndex;
        }
        this.writer.write(s);
        this.bufferLength += s.length();
    }

    private int getCurrentPos() {
        return this.bufferLength;
    }

    private int getIndent() {
        return this.getCurrentPos() - this.lastNewLineIndex;
    }

    private void writeIndent(int indent) {
        for (int i = 1; i < indent; ++i) {
            this.write(" ");
        }
    }

    private void writeAsURI(String s) {
        this.write("<");
        if (s.startsWith(this.base)) {
            this.write(s.substring(this.base.length()));
        } else {
            this.write(s);
        }
        this.write(">");
    }

    private void write(URI uri) {
        if (uri.equals(this.getOntology().getURI())) {
            this.writeAsURI(uri.toString());
        } else {
            String uriString = uri.toString();
            String name = this.nsm.getQName(uriString);
            if (name.equals(uriString)) {
                this.writeAsURI(uri.toString());
            } else if (name.indexOf(58) != -1) {
                this.write(name);
            } else {
                this.write(":");
                this.write(name);
            }
        }
    }

    private void writeNewLine() {
        this.write("\n");
        int tabIndent = 0;
        if (!this.tabs.isEmpty()) {
            tabIndent = this.tabs.peek();
        }
        for (int i = 1; i < tabIndent; ++i) {
            this.write(" ");
        }
    }

    private void write(RDFNode node) {
        if (node.isLiteral()) {
            this.write((RDFLiteralNode)node);
        } else {
            this.write((RDFResourceNode)node);
        }
    }

    private void write(RDFLiteralNode node) {
        if (node.isTyped()) {
            if (node.getDatatype().equals(XSDVocabulary.INTEGER.getURI())) {
                this.write(node.getLiteral());
            } else if (node.getDatatype().equals(XSDVocabulary.DOUBLE.getURI())) {
                this.write(node.getLiteral());
            } else if (node.getDatatype().equals(XSDVocabulary.DECIMAL.getURI())) {
                this.write(node.getLiteral());
            } else {
                this.writeStringLiteral(node.getLiteral());
                this.write("^^");
                this.write(node.getDatatype());
            }
        } else {
            this.writeStringLiteral(node.getLiteral());
            if (node.getLang() != null) {
                this.write("@");
                this.write(node.getLang());
            }
        }
    }

    private void writeStringLiteral(String literal) {
        if (literal.indexOf(10) != -1) {
            this.write("\"\"\"");
            this.write(literal);
            this.write("\"\"\"");
        } else {
            this.write("\"");
            this.write(literal);
            this.write("\"");
        }
    }

    private void write(RDFResourceNode node) {
        if (!node.isAnonymous()) {
            this.write(node.getURI());
        } else {
            this.pushTab();
            if (!this.isObjectList(node)) {
                this.render(node);
            } else {
                ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                this.toJavaList(node, list);
                this.pushTab();
                this.write("(");
                this.write(" ");
                this.pushTab();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.write((RDFNode)it.next());
                    if (!it.hasNext()) continue;
                    this.writeNewLine();
                }
                this.popTab();
                this.writeNewLine();
                this.write(")");
                this.popTab();
            }
            this.popTab();
        }
    }

    private void writeType(RDFResourceNode subject, RDFResourceNode object) {
        this.write(subject);
        this.write(" a ");
        this.write(object);
    }

    protected void beginDocument() {
        this.writeNamespaces();
        this.write("@base ");
        this.write("<");
        this.write(this.getOntology().getURI().toString());
        this.write("> .");
        this.writeNewLine();
        this.writeNewLine();
    }

    protected void endDocument() {
        this.writer.flush();
    }

    protected void writeClassComment(OWLClass cls) {
        this.writeComment(cls.getURI().toString());
    }

    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writeComment(prop.getURI().toString());
    }

    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writeComment(prop.getURI().toString());
    }

    protected void writeIndividualComments(OWLIndividual ind) {
        this.writeComment(ind.getURI().toString());
    }

    private void writeComment(String comment) {
        this.write("###  ");
        this.write(comment);
        this.writeNewLine();
        this.writeNewLine();
    }

    protected void endObject() {
        this.writeNewLine();
        this.writeNewLine();
        this.writeNewLine();
    }

    protected void writeBanner(String name) {
        this.writeNewLine();
        this.writeNewLine();
        this.writer.println("#################################################################");
        this.writer.println("#");
        this.writer.print("#    ");
        this.writer.println(name);
        this.writer.println("#");
        this.writer.println("#################################################################");
        this.writeNewLine();
        this.writeNewLine();
    }

    public void render(RDFResourceNode node) {
        if (this.pending.contains(node)) {
            throw new IllegalStateException("Rendering cycle!  This indicates structure sharing and should not happen!");
        }
        this.pending.add(node);
        TreeSet<RDFTriple> triples = new TreeSet<RDFTriple>(new RDFRendererBase.TripleComparator());
        triples.addAll(this.getGraph().getTriplesForSubject(node));
        RDFResourceNode lastSubject = null;
        RDFResourceNode lastPredicate = null;
        boolean first = true;
        for (RDFTriple triple : triples) {
            RDFResourceNode subj = triple.getSubject();
            RDFResourceNode pred = triple.getProperty();
            if (lastSubject != null && (subj.equals(lastSubject) || subj.isAnonymous())) {
                if (lastPredicate != null && pred.equals(lastPredicate)) {
                    this.write(" ,");
                    this.writeNewLine();
                    this.write(triple.getObject());
                } else {
                    this.write(" ;");
                    this.popTab();
                    if (!subj.isAnonymous()) {
                        this.writeNewLine();
                    }
                    this.writeNewLine();
                    this.write(triple.getProperty());
                    this.write(" ");
                    this.pushTab();
                    this.write(triple.getObject());
                }
            } else {
                if (!first) {
                    this.popTab();
                    this.popTab();
                    this.writeNewLine();
                }
                if (!node.isAnonymous()) {
                    this.write(triple.getSubject());
                    this.write(" ");
                } else {
                    this.pushTab();
                    this.write("[");
                    this.write(" ");
                }
                this.pushTab();
                this.write(triple.getProperty());
                this.write(" ");
                this.pushTab();
                this.write(triple.getObject());
            }
            lastSubject = subj;
            lastPredicate = pred;
            first = false;
        }
        this.write(" .");
        if (node.isAnonymous()) {
            this.popTab();
            this.popTab();
            this.writeNewLine();
            this.write("]");
            this.popTab();
        } else {
            this.popTab();
            this.popTab();
        }
        this.writer.flush();
        this.pending.remove(node);
    }
}

