/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.AbstractCompositeOntologyChange;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    private Set<? extends OWLDescription> descriptions;
    private boolean usePairwiseDisjointAxioms;
    private OWLOntology targetOntology;
    private List<OWLOntologyChange> changes;

    public MakeClassesMutuallyDisjoint(OWLDataFactory dataFactory, Set<? extends OWLDescription> descriptions, boolean usePairwiseDisjointAxioms, OWLOntology targetOntology) {
        super(dataFactory);
        this.descriptions = descriptions;
        this.usePairwiseDisjointAxioms = usePairwiseDisjointAxioms;
        this.targetOntology = targetOntology;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        if (this.usePairwiseDisjointAxioms) {
            ArrayList<? extends OWLDescription> descList = new ArrayList<OWLDescription>(this.descriptions);
            for (int i = 0; i < descList.size(); ++i) {
                for (int j = i + 1; j < descList.size(); ++j) {
                    this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(CollectionFactory.createSet((OWLDescription)descList.get(i), (OWLDescription)descList.get(j)))));
                }
            }
        } else {
            this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(this.descriptions)));
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

