/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.semanticweb.owl.io.IOProperties;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLParser;
import org.semanticweb.owl.io.OWLParserException;
import org.semanticweb.owl.io.OWLParserIOException;
import org.semanticweb.owl.io.PhysicalURIInputSource;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.xml.sax.InputSource;

public abstract class AbstractOWLParser
implements OWLParser {
    private static Logger logger = Logger.getLogger(AbstractOWLParser.class.getName());
    private OWLOntologyManager owlOntologyManager;

    protected AbstractOWLParser() {
    }

    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = owlOntologyManager;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    protected String getRequestTypes() {
        return "application/rdf+xml, application/xml; q=0.5, text/xml; q=0.3, */*; q=0.2";
    }

    protected InputStream getInputStream(URI uri) throws OWLParserException {
        try {
            BufferedInputStream is;
            String requestType = this.getRequestTypes();
            URLConnection conn = uri.toURL().openConnection();
            conn.addRequestProperty("Accept", requestType);
            if (IOProperties.getInstance().isConnectionAcceptHTTPCompression()) {
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            conn.setConnectTimeout(IOProperties.getInstance().getConnectionTimeout());
            if ("gzip".equals(conn.getContentEncoding())) {
                logger.fine("URL connection input stream is compressed using gzip");
                is = new BufferedInputStream(new GZIPInputStream(conn.getInputStream()));
            } else if ("deflate".equals(conn.getContentEncoding())) {
                logger.fine("URL connection input stream is compressed using deflate");
                is = new BufferedInputStream(new InflaterInputStream(conn.getInputStream(), new Inflater(true)));
            } else {
                is = new BufferedInputStream(conn.getInputStream());
            }
            if (uri.toString().endsWith(".zip")) {
                ZipInputStream zis = new ZipInputStream(is);
                zis.getNextEntry();
                is = new BufferedInputStream(zis);
            }
            return is;
        }
        catch (IOException e) {
            throw new OWLParserIOException(e);
        }
    }

    protected InputSource getInputSource(OWLOntologyInputSource inputSource) throws OWLParserException {
        InputSource is = inputSource.isReaderAvailable() ? new InputSource(inputSource.getReader()) : (inputSource.isInputStreamAvailable() ? new InputSource(inputSource.getInputStream()) : new InputSource(this.getInputStream(inputSource.getPhysicalURI())));
        is.setSystemId(inputSource.getPhysicalURI().toString());
        return is;
    }

    public OWLOntologyFormat parse(URI physicalURI, OWLOntology ontology) throws OWLOntologyCreationException {
        return this.parse(new PhysicalURIInputSource(physicalURI), ontology);
    }
}

