/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.vocab.NamespaceOWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFXMLOntologyFormat
extends NamespaceOWLOntologyFormat {
    private Map<URI, Set<OWLAnnotation>> annotationURI2Annotation = new HashMap<URI, Set<OWLAnnotation>>();
    private Set<URI> annotationURIs = new HashSet<URI>();
    private long numberOfTriplesProcessedDuringLoading;

    public long getNumberOfTriplesProcessedDuringLoading() {
        return this.numberOfTriplesProcessedDuringLoading;
    }

    public void setNumberOfTriplesProcessedDuringLoading(long numberOfTriplesProcessedDuringLoading) {
        this.numberOfTriplesProcessedDuringLoading = numberOfTriplesProcessedDuringLoading;
    }

    public String toString() {
        return "RDF/XML";
    }

    public Set<URI> getAnnotationURIs() {
        return Collections.unmodifiableSet(this.annotationURIs);
    }

    public void addAnnotationURI(URI uri) {
        this.annotationURIs.add(uri);
        if (this.annotationURI2Annotation.get(uri) == null) {
            this.annotationURI2Annotation.put(uri, new HashSet());
        }
    }

    public void addAnnotationURIAnnotation(URI uri, OWLAnnotation anno) {
        this.addAnnotationURI(uri);
        Set<OWLAnnotation> annos = this.annotationURI2Annotation.get(uri);
        if (annos == null) {
            annos = new HashSet<OWLAnnotation>();
            this.annotationURI2Annotation.put(uri, annos);
        }
        annos.add(anno);
    }

    public void removeAnnotationURIAnnotation(URI uri, OWLAnnotation anno) {
        Set<OWLAnnotation> annos = this.annotationURI2Annotation.get(uri);
        if (annos != null) {
            annos.remove(anno);
        }
    }

    public void clearAnnotationURIAnnotations() {
        this.annotationURI2Annotation.clear();
    }

    public Map<URI, Set<OWLAnnotation>> getAnnotationURIAnnotations() {
        return Collections.unmodifiableMap(this.annotationURI2Annotation);
    }
}

