/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectPropertyUtil {
    private OWLDataFactory dataFactory;
    private OWLOntologySetProvider setProvider;

    public OWLObjectPropertyUtil(OWLDataFactory dataFactory, OWLOntologySetProvider ontologySetProvider) {
        this.dataFactory = dataFactory;
        this.setProvider = ontologySetProvider;
    }

    protected Set<OWLOntology> getOntologies() {
        return this.setProvider.getOntologies();
    }

    public boolean isSimple(OWLObjectPropertyExpression expression) {
        return false;
    }

    public Set<OWLObjectPropertyExpressionPair> getReflexiveTransitiveClosure(Set<OWLObjectPropertyExpressionPair> pairs) {
        return null;
    }

    public Set<OWLObjectPropertyExpressionPair> getObjectPropertyHierarchyRelations() {
        HashSet<OWLObjectPropertyExpressionPair> pairs = new HashSet<OWLObjectPropertyExpressionPair>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLObjectSubPropertyAxiom oWLObjectSubPropertyAxiom : ont.getAxioms(AxiomType.SUB_OBJECT_PROPERTY)) {
                this.addPairs(pairs, (OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSubProperty(), (OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSuperProperty());
            }
            for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ont.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
                ArrayList props = new ArrayList(oWLEquivalentObjectPropertiesAxiom.getProperties());
                for (int i = 0; i < props.size() - 1; ++i) {
                    for (int j = i + 1; j < props.size(); ++j) {
                        OWLObjectPropertyExpression propA = (OWLObjectPropertyExpression)props.get(i);
                        OWLObjectPropertyExpression propB = (OWLObjectPropertyExpression)props.get(j);
                        this.addPairs(pairs, propA, propB);
                        this.addPairs(pairs, propB, propA);
                    }
                }
            }
            for (OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom : ont.getAxioms(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
                this.addPairs(pairs, oWLInverseObjectPropertiesAxiom.getFirstProperty(), this.getInverse(oWLInverseObjectPropertiesAxiom.getSecondProperty()));
                this.addPairs(pairs, this.getInverse(oWLInverseObjectPropertiesAxiom.getSecondProperty()), oWLInverseObjectPropertiesAxiom.getFirstProperty());
            }
            for (OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom : ont.getAxioms(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                this.addPairs(pairs, (OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty(), this.getInverse((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()));
            }
        }
        return pairs;
    }

    private void addPairs(Set<OWLObjectPropertyExpressionPair> pairs, OWLObjectPropertyExpression left, OWLObjectPropertyExpression right) {
        OWLObjectPropertyExpression simpLeft = this.getSimplifiedPropertyExpression(left);
        OWLObjectPropertyExpression simpRight = this.getSimplifiedPropertyExpression(right);
        pairs.add(new OWLObjectPropertyExpressionPair(simpLeft, simpRight));
        pairs.add(new OWLObjectPropertyExpressionPair(this.getInverse(simpLeft), this.getInverse(simpRight)));
    }

    public boolean isComposite(OWLObjectPropertyExpression expression) {
        OWLObjectPropertyExpression simpProp = this.getSimplifiedPropertyExpression(expression);
        OWLObjectPropertyExpression simpPropInv = simpProp.isAnonymous() ? ((OWLObjectPropertyInverse)simpProp).getInverse() : this.getInverse(simpProp);
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLObjectPropertyChainSubPropertyAxiom ax : ont.getPropertyChainSubPropertyAxioms()) {
                if (!ax.getSuperProperty().equals(simpProp) && !ax.getSuperProperty().equals(simpPropInv)) continue;
                return true;
            }
            if (ont.getTransitiveObjectPropertyAxiom(simpProp) != null) {
                return true;
            }
            if (ont.getTransitiveObjectPropertyAxiom(simpPropInv) == null) continue;
            return true;
        }
        return false;
    }

    public OWLObjectPropertyExpression getSimplifiedPropertyExpression(OWLObjectPropertyExpression prop) {
        if (!prop.isAnonymous()) {
            return prop;
        }
        OWLObjectPropertyExpression invProp = ((OWLObjectPropertyInverse)prop).getInverse();
        if (invProp.isAnonymous()) {
            OWLObjectPropertyExpression simplifiedProp = ((OWLObjectPropertyInverse)invProp).getInverse();
            return this.getSimplifiedPropertyExpression(simplifiedProp);
        }
        return prop;
    }

    public OWLObjectPropertyExpression getInverse(OWLObjectPropertyExpression prop) {
        if (prop.isAnonymous()) {
            return ((OWLObjectPropertyInverse)prop).getInverse();
        }
        return this.dataFactory.getOWLObjectPropertyInverse(prop);
    }

    public static class OWLObjectPropertyExpressionPair {
        private OWLObjectPropertyExpression left;
        private OWLObjectPropertyExpression right;

        public OWLObjectPropertyExpressionPair(OWLObjectPropertyExpression left, OWLObjectPropertyExpression right) {
            this.left = left;
            this.right = right;
        }

        public OWLObjectPropertyExpression getLeft() {
            return this.left;
        }

        public OWLObjectPropertyExpression getRight() {
            return this.right;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OWLObjectPropertyExpressionPair)) {
                return false;
            }
            OWLObjectPropertyExpressionPair other = (OWLObjectPropertyExpressionPair)obj;
            return this.left.equals(other.left) && this.right.equals(other.right);
        }

        public int hashCode() {
            int hashCode = 37;
            hashCode = hashCode * 37 + this.left.hashCode();
            hashCode = hashCode * 37 + this.right.hashCode();
            return hashCode;
        }
    }
}

