/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.List;
import java.util.Map;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAssertionValueShortFormProvider
implements ShortFormProvider {
    private List<OWLPropertyExpression> properties;
    private Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap;
    private OWLOntologySetProvider ontologySetProvider;
    private ShortFormProvider alternateShortFormProvider;

    public PropertyAssertionValueShortFormProvider(List<OWLPropertyExpression> properties, Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider) {
        this(properties, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public PropertyAssertionValueShortFormProvider(List<OWLPropertyExpression> properties, Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider) {
        this.properties = properties;
        this.preferredLanguageMap = preferredLanguageMap;
        this.ontologySetProvider = ontologySetProvider;
        this.alternateShortFormProvider = alternateShortFormProvider;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        int lastURIMatchIndex = Integer.MAX_VALUE;
        int lastLangMatchIndex = Integer.MAX_VALUE;
        if (!(entity instanceof OWLIndividual)) {
            return this.alternateShortFormProvider.getShortForm(entity);
        }
        OWLIndividual individual = (OWLIndividual)entity;
        OWLObject candidateValue = null;
        for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
            int index;
            for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : ontology.getObjectPropertyAssertionAxioms(individual)) {
                index = this.properties.indexOf(oWLObjectPropertyAssertionAxiom.getProperty());
                if (index == -1 || index >= lastURIMatchIndex) continue;
                candidateValue = (OWLObject)oWLObjectPropertyAssertionAxiom.getObject();
            }
            for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : ontology.getDataPropertyAssertionAxioms(individual)) {
                index = this.properties.indexOf(oWLDataPropertyAssertionAxiom.getProperty());
                if (index == -1) continue;
                if (index == lastURIMatchIndex) {
                    int langIndex;
                    List<String> langList;
                    OWLUntypedConstant untypedConstantVal;
                    Object obj = oWLDataPropertyAssertionAxiom.getObject();
                    if (!(obj instanceof OWLUntypedConstant) || !(untypedConstantVal = (OWLUntypedConstant)obj).hasLang() || (langList = this.preferredLanguageMap.get(oWLDataPropertyAssertionAxiom.getProperty())) == null || (langIndex = langList.indexOf(untypedConstantVal.getLang())) == -1 || langIndex >= lastLangMatchIndex) continue;
                    lastLangMatchIndex = langIndex;
                    candidateValue = (OWLObject)oWLDataPropertyAssertionAxiom.getObject();
                    continue;
                }
                if (index >= lastURIMatchIndex) continue;
                lastURIMatchIndex = index;
                candidateValue = (OWLObject)oWLDataPropertyAssertionAxiom.getObject();
            }
        }
        if (candidateValue != null) {
            return this.getRendering(candidateValue);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLConstant) {
            return ((OWLConstant)object).getLiteral();
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<OWLPropertyExpression> getProperties() {
        return this.properties;
    }

    public Map<OWLDataPropertyExpression, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }
}

