/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.Set;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;
import org.semanticweb.owl.util.RootClassChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRootClassChecker
implements RootClassChecker {
    private Set<OWLOntology> ontologies;
    private RootClassCheckerHelper checker = new RootClassCheckerHelper();
    private NamedSuperChecker superChecker = new NamedSuperChecker();

    public SimpleRootClassChecker(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
    }

    @Override
    public boolean isRootClass(OWLClass cls) {
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms(cls)) {
                this.checker.setOWLClass(cls);
                ax.accept(this.checker);
                if (this.checker.isRoot()) continue;
                return false;
            }
        }
        return true;
    }

    private class RootClassCheckerHelper
    extends OWLAxiomVisitorAdapter {
        private boolean isRoot;
        private OWLClass cls;

        private RootClassCheckerHelper() {
        }

        public void setOWLClass(OWLClass cls) {
            this.isRoot = true;
            this.cls = cls;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public void visit(OWLSubClassAxiom axiom) {
            if (axiom.getSubClass().equals(this.cls)) {
                SimpleRootClassChecker.this.superChecker.reset();
                axiom.getSuperClass().accept(SimpleRootClassChecker.this.superChecker);
                this.isRoot = !SimpleRootClassChecker.this.superChecker.namedSuper;
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLDescription> descs = axiom.getDescriptions();
            if (!descs.contains(this.cls)) {
                return;
            }
            for (OWLDescription desc : descs) {
                if (desc.equals(this.cls)) continue;
                SimpleRootClassChecker.this.superChecker.reset();
                desc.accept(SimpleRootClassChecker.this.superChecker);
                if (!SimpleRootClassChecker.this.superChecker.namedSuper) continue;
                this.isRoot = false;
                return;
            }
            this.isRoot = !SimpleRootClassChecker.this.superChecker.namedSuper;
        }
    }

    private class NamedSuperChecker
    extends OWLDescriptionVisitorAdapter {
        private boolean namedSuper;

        private NamedSuperChecker() {
        }

        public void reset() {
            this.namedSuper = false;
        }

        public void visit(OWLClass desc) {
            this.namedSuper = true;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
                if (!this.namedSuper) continue;
                break;
            }
        }
    }
}

