/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.vocab;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DublinCoreVocabulary {
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    private URI uri;
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static Set<URI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.uri = URI.create(NAME_SPACE + name);
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    static {
        ALL_URIS = new HashSet<URI>();
        for (DublinCoreVocabulary v : DublinCoreVocabulary.values()) {
            ALL_URIS.add(v.getURI());
        }
    }
}

