/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import java.net.URI;
import java.util.Stack;
import java.util.logging.Logger;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGRenderer
implements OWLObjectVisitor {
    private static final Logger logger = Logger.getLogger(DIGRenderer.class.getName());
    private OWLOntologyManager manager;
    private Document document;
    private Stack<Element> nodeStack;
    public static final URI THING_URI = OWLRDFVocabulary.OWL_THING.getURI();
    public static final URI NOTHING_URI = OWLRDFVocabulary.OWL_NOTHING.getURI();

    public DIGRenderer(OWLOntologyManager manager, Document document, Element node) {
        this.manager = manager;
        this.document = document;
        this.nodeStack = new Stack();
        this.nodeStack.push(node);
    }

    private void createAndPushNode(String name) {
        Element n = this.document.createElement(name);
        this.getCurrentNode().appendChild(n);
        this.nodeStack.push(n);
    }

    private Element getCurrentNode() {
        return this.nodeStack.peek();
    }

    private void popCurrentNode() {
        this.nodeStack.pop();
    }

    public void visit(OWLSubClassAxiom axiom) {
        this.createAndPushNode("impliesc");
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLDescription descA : axiom.getDescriptions()) {
            for (OWLDescription descB : axiom.getDescriptions()) {
                if (descA.equals(descB)) continue;
                this.createAndPushNode("equalc");
                descA.accept(this);
                descB.accept(this);
                this.popCurrentNode();
            }
        }
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.createAndPushNode("disjoint");
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept(this);
        }
        this.popCurrentNode();
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.createAndPushNode("disjoint");
        for (OWLIndividual ind : axiom.getIndividuals()) {
            this.createAndPushNode("iset");
            ind.accept(this);
            this.popCurrentNode();
        }
        this.popCurrentNode();
    }

    public void visit(OWLSameIndividualsAxiom axiom) {
        for (OWLIndividual indA : axiom.getIndividuals()) {
            for (OWLIndividual indB : axiom.getIndividuals()) {
                if (indA.equals(indB)) continue;
                this.createAndPushNode("equalc");
                this.createAndPushNode("iset");
                indA.accept(this);
                this.popCurrentNode();
                this.createAndPushNode("iset");
                indB.accept(this);
                this.popCurrentNode();
                this.popCurrentNode();
            }
        }
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        throw new RuntimeException("Anti-symmetric properties are not supported in DIG 1.1");
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        throw new RuntimeException("Reflexive properties are not supported in DIG 1.1");
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    public void visit(OWLImportsDeclaration axiom) {
    }

    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.createAndPushNode("domain");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getDomain().accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression p1 : axiom.getProperties()) {
            for (OWLObjectPropertyExpression p2 : axiom.getProperties()) {
                if (p1.equals(p2)) continue;
                this.createAndPushNode("equalr");
                p1.accept(this);
                p2.accept(this);
                this.popCurrentNode();
            }
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.createAndPushNode("equalr");
        axiom.getFirstProperty().accept(this);
        OWLObjectPropertyExpression invProp = axiom.getSecondProperty();
        this.manager.getOWLDataFactory().getOWLObjectPropertyInverse(invProp).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        throw new RuntimeException("Negative data property relationships cannot be represented in DIG 1.1");
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        throw new RuntimeException("Disjoint data properties cannot be represented in DIG 1.1");
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        throw new RuntimeException("Disjoint object properties cannot be represented in DIG 1.1");
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.createAndPushNode("related");
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.createAndPushNode("functional");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.createAndPushNode("impliesr");
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.createAndPushNode("equalr");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.createAndPushNode("inverse");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.popCurrentNode();
        this.popCurrentNode();
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        logger.info("Ignoring functional data property axiom, because all data properties are functional in DIG 1.1");
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        throw new RuntimeException("Equivalent data properties are not supported in DIG 1.1");
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.createAndPushNode("instanceof");
        axiom.getIndividual().accept(this);
        axiom.getDescription().accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.createAndPushNode("transitive");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        throw new RuntimeException("Irreflexive properties are not supported in DIG 1.1");
    }

    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.createAndPushNode("impliesr");
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.createAndPushNode("functional");
        this.createAndPushNode("inverse");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.popCurrentNode();
        this.popCurrentNode();
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.createAndPushNode("range");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLDescription)axiom.getRange()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
    }

    public void visit(OWLObjectPropertyInverse property) {
        this.createAndPushNode("inverse");
        property.getInverse().accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLDataProperty property) {
    }

    public void visit(OWLObjectIntersectionOf node) {
        this.createAndPushNode("and");
        for (OWLDescription desc : node.getOperands()) {
            desc.accept(this);
        }
        this.popCurrentNode();
    }

    public void visit(OWLIndividual node) {
        this.createAndPushNode("individual");
        this.getCurrentNode().setAttribute("name", node.getURI().toString());
        this.popCurrentNode();
    }

    public void visit(OWLObjectAllRestriction node) {
        this.createAndPushNode("all");
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        ((OWLDescription)node.getFiller()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.createAndPushNode("atleast");
        this.getCurrentNode().setAttribute("num", Integer.toString(desc.getCardinality()));
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.createAndPushNode("atleast");
        this.getCurrentNode().setAttribute("num", Integer.toString(desc.getCardinality()));
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
        this.popCurrentNode();
        this.createAndPushNode("atmost");
        this.getCurrentNode().setAttribute("num", Integer.toString(desc.getCardinality()));
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.createAndPushNode("atmost");
        this.getCurrentNode().setAttribute("num", Integer.toString(desc.getCardinality()));
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLDescription)desc.getFiller()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLObjectProperty node) {
        this.createAndPushNode("ratom");
        this.getCurrentNode().setAttribute("name", node.getURI().toString());
        this.popCurrentNode();
    }

    public void visit(OWLObjectSomeRestriction node) {
        this.createAndPushNode("some");
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        ((OWLDescription)node.getFiller()).accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLObjectValueRestriction node) {
        this.createAndPushNode("some");
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.createAndPushNode("iset");
        ((OWLIndividual)node.getValue()).accept(this);
        this.popCurrentNode();
        this.popCurrentNode();
    }

    public void visit(OWLObjectComplementOf node) {
        this.createAndPushNode("not");
        node.getOperand().accept(this);
        this.popCurrentNode();
    }

    public void visit(OWLOntology ontology) {
        for (OWLClass cls : ontology.getReferencedClasses()) {
            this.createAndPushNode("defconcept");
            this.getCurrentNode().setAttribute("name", cls.getURI().toString());
            this.popCurrentNode();
        }
        for (OWLObjectProperty prop : ontology.getReferencedObjectProperties()) {
            this.createAndPushNode("defrole");
            this.getCurrentNode().setAttribute("name", prop.getURI().toString());
            this.popCurrentNode();
        }
        for (OWLIndividual ind : ontology.getReferencedIndividuals()) {
            this.createAndPushNode("defindividual");
            this.getCurrentNode().setAttribute("name", ind.getURI().toString());
            this.popCurrentNode();
        }
        for (OWLAxiom ax : ontology.getAxioms()) {
            ax.accept(this);
        }
    }

    public void visit(OWLObjectUnionOf node) {
        this.createAndPushNode("or");
        for (OWLDescription desc : node.getOperands()) {
            desc.accept(this);
        }
        this.popCurrentNode();
    }

    public void visit(OWLClass node) {
        if (node.getURI().equals(NOTHING_URI)) {
            this.createAndPushNode("bottom");
            this.popCurrentNode();
        } else if (node.getURI().equals(THING_URI)) {
            this.createAndPushNode("top");
            this.popCurrentNode();
        } else {
            this.createAndPushNode("catom");
            this.getCurrentNode().setAttribute("name", node.getURI().toString());
            this.popCurrentNode();
        }
    }

    public void visit(OWLObjectOneOf node) {
        this.createAndPushNode("iset");
        for (OWLIndividual ind : node.getIndividuals()) {
            ind.accept(this);
        }
        this.popCurrentNode();
    }

    public void visit(OWLObjectSelfRestriction desc) {
    }

    public void visit(OWLDataSomeRestriction desc) {
    }

    public void visit(OWLDataAllRestriction desc) {
    }

    public void visit(OWLDataValueRestriction desc) {
    }

    public void visit(OWLDataMinCardinalityRestriction desc) {
    }

    public void visit(OWLDataExactCardinalityRestriction desc) {
    }

    public void visit(OWLDataMaxCardinalityRestriction desc) {
    }

    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    public void visit(OWLDataType node) {
    }

    public void visit(OWLDataComplementOf node) {
    }

    public void visit(OWLDataOneOf node) {
    }

    public void visit(OWLDataRangeRestriction node) {
    }

    public void visit(OWLDataRangeFacetRestriction node) {
    }

    public void visit(OWLTypedConstant node) {
    }

    public void visit(OWLUntypedConstant node) {
    }

    public void visit(OWLConstantAnnotation annotation) {
    }

    public void visit(OWLObjectAnnotation annotation) {
    }

    public void visit(SWRLRule rule) {
    }

    public void visit(SWRLClassAtom node) {
    }

    public void visit(SWRLDataRangeAtom node) {
    }

    public void visit(SWRLObjectPropertyAtom node) {
    }

    public void visit(SWRLDataValuedPropertyAtom node) {
    }

    public void visit(SWRLBuiltInAtom node) {
    }

    public void visit(SWRLAtomDVariable node) {
    }

    public void visit(SWRLAtomIVariable node) {
    }

    public void visit(SWRLAtomIndividualObject node) {
    }

    public void visit(SWRLAtomConstantObject node) {
    }

    public void visit(SWRLDifferentFromAtom node) {
    }

    public void visit(SWRLSameAsAtom node) {
    }
}

