/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import nextapp.echo2.webrender.ClientProperties;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.UserInstance;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.SynchronizeService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;

public class ClientAnalyzerProcessor
implements SynchronizeService.ClientMessagePartProcessor {
    private static final Set VALID_PROPERTIES;

    private void analyze(ClientProperties clientProperties) {
        Connection conn = WebRenderServlet.getActiveConnection();
        Enumeration localeEnum = conn.getRequest().getLocales();
        ArrayList localeList = new ArrayList();
        while (localeEnum.hasMoreElements()) {
            localeList.add(localeEnum.nextElement());
        }
        clientProperties.setProperty("locales", localeList.toArray(new Locale[localeList.size()]));
        clientProperties.setProperty("remoteHost", conn.getRequest().getRemoteHost());
        String userAgent = clientProperties.getString("navigatorUserAgent").toLowerCase();
        boolean browserOpera = userAgent.indexOf("opera") != -1;
        boolean browserSafari = userAgent.indexOf("safari") != -1;
        boolean browserKonqueror = userAgent.indexOf("konqueror") != -1;
        boolean deceptiveUserAgent = browserOpera || browserSafari || browserKonqueror;
        boolean browserMozilla = !deceptiveUserAgent && userAgent.indexOf("gecko") != -1;
        boolean browserFireFox = userAgent.indexOf("firefox") != -1;
        boolean browserInternetExplorer = !deceptiveUserAgent && userAgent.indexOf("msie") != -1;
        int majorVersion = -1;
        int minorVersion = -1;
        if (browserOpera) {
            clientProperties.setProperty("browserOpera", Boolean.TRUE);
            majorVersion = userAgent.indexOf("opera/9") != -1 || userAgent.indexOf("opera 9") != -1 ? 9 : (userAgent.indexOf("opera/8") != -1 || userAgent.indexOf("opera 8") != -1 ? 8 : 9);
        } else if (browserKonqueror) {
            clientProperties.setProperty("browserKonqueror", Boolean.TRUE);
        } else if (browserSafari) {
            clientProperties.setProperty("browserSafari", Boolean.TRUE);
        } else if (browserMozilla) {
            clientProperties.setProperty("browserMozilla", Boolean.TRUE);
            if (browserFireFox) {
                clientProperties.setProperty("browserMozillaFirefox", Boolean.TRUE);
            }
        } else if (browserInternetExplorer) {
            clientProperties.setProperty("browserInternetExplorer", Boolean.TRUE);
            if (userAgent.indexOf("msie 6.") != -1) {
                majorVersion = 6;
            } else if (userAgent.indexOf("msie 7.") != -1) {
                majorVersion = 7;
            }
        }
        if (majorVersion != -1) {
            clientProperties.setProperty("browserVersionMajor", Integer.toString(majorVersion));
        }
        if (minorVersion != -1) {
            clientProperties.setProperty("browserVersionMinor", Integer.toString(minorVersion));
        }
        if (browserInternetExplorer) {
            clientProperties.setProperty("quirkIERepaint", Boolean.TRUE);
            clientProperties.setProperty("quirkTextareaContent", Boolean.TRUE);
            clientProperties.setProperty("quirkIETextareaNewlineObliteration", Boolean.TRUE);
            clientProperties.setProperty("quirkIESelectListDomUpdate", Boolean.TRUE);
            clientProperties.setProperty("quirkCssBorderCollapseInside", Boolean.TRUE);
            clientProperties.setProperty("quirkCssBorderCollapseFor0Padding", Boolean.TRUE);
            clientProperties.setProperty("notSupportedCssOpacity", Boolean.TRUE);
            clientProperties.setProperty("quirkDelayedFocusRequired", Boolean.TRUE);
            clientProperties.setProperty("proprietaryIECssExpressionsSupported", Boolean.TRUE);
            clientProperties.setProperty("proprietaryEventMouseEnterLeaveSupported", Boolean.TRUE);
            clientProperties.setProperty("proprietaryIEOpacityFilterRequired", Boolean.TRUE);
            clientProperties.setProperty("quirkIETablePercentWidthScrollbarError", Boolean.TRUE);
            clientProperties.setProperty("quirkIESelectPercentWidth", Boolean.TRUE);
            if (majorVersion < 7) {
                clientProperties.setProperty("proprietaryIEPngAlphaFilterRequired", Boolean.TRUE);
                clientProperties.setProperty("quirkCssPositioningOneSideOnly", Boolean.TRUE);
                clientProperties.setProperty("quirkCssBackgroundAttachmentUseFixed", Boolean.TRUE);
                clientProperties.setProperty("quirkIESelectZIndex", Boolean.TRUE);
            }
        }
        if (browserOpera) {
            clientProperties.setProperty("quirkTextareaContent", Boolean.TRUE);
            clientProperties.setProperty("quirkOperaNoCssText", Boolean.TRUE);
            clientProperties.setProperty("quirkSelectRequiresNullOption", Boolean.TRUE);
            clientProperties.setProperty("quirkIESelectPercentWidth", Boolean.TRUE);
            if (majorVersion < 9) {
                clientProperties.setProperty("notSupportedCssOpacity", Boolean.TRUE);
            }
        }
        if (browserMozilla) {
            clientProperties.setProperty("quirkSelectRequiresNullOption", Boolean.TRUE);
            clientProperties.setProperty("quirkMozillaTextInputRepaint", Boolean.TRUE);
            clientProperties.setProperty("quirkMozillaPerformanceLargeDomRemove", Boolean.TRUE);
        }
        if (browserKonqueror) {
            clientProperties.setProperty("quirkSelectRequiresNullOption", Boolean.TRUE);
            clientProperties.setProperty("quirkIESelectPercentWidth", Boolean.TRUE);
            clientProperties.setProperty("notSupportedCssManipulation", Boolean.TRUE);
        }
        if (browserSafari) {
            clientProperties.setProperty("quirkSelectRequiresNullOption", Boolean.TRUE);
            clientProperties.setProperty("notSupportedCssManipulation", Boolean.TRUE);
            String unescapeTest = clientProperties.getString("unescapedXhrTest");
            if (unescapeTest.equals("&")) {
                clientProperties.setProperty("quirkSafariUnescapedXHR", Boolean.TRUE);
            }
        }
    }

    public String getName() {
        return "EchoClientAnalyzer";
    }

    public void process(UserInstance userInstance, Element messagePartElement) {
        ClientProperties clientProperties = new ClientProperties();
        Element[] propertyElements = DomUtil.getChildElementsByTagName(messagePartElement, "property");
        for (int i = 0; i < propertyElements.length; ++i) {
            String propertyName = propertyElements[i].getAttribute("name");
            if (!VALID_PROPERTIES.contains(propertyName)) continue;
            String type = propertyElements[i].getAttribute("type");
            if ("text".equals(type)) {
                clientProperties.setProperty(propertyName, propertyElements[i].getAttribute("value"));
                continue;
            }
            if ("integer".equals(type)) {
                try {
                    clientProperties.setProperty(propertyName, new Integer(propertyElements[i].getAttribute("value")));
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (!"boolean".equals(type)) continue;
            clientProperties.setProperty(propertyName, new Boolean("true".equals(propertyElements[i].getAttribute("value"))));
        }
        userInstance.setClientProperties(clientProperties);
        this.analyze(clientProperties);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("navigatorAppCodeName");
        set.add("navigatorAppName");
        set.add("navigatorAppVersion");
        set.add("navigatorCookieEnabled");
        set.add("navigatorJavaEnabled");
        set.add("navigatorLanguage");
        set.add("navigatorPlatform");
        set.add("navigatorUserAgent");
        set.add("screenWidth");
        set.add("screenHeight");
        set.add("screenColorDepth");
        set.add("utcOffset");
        set.add("unescapedXhrTest");
        VALID_PROPERTIES = Collections.unmodifiableSet(set);
    }
}

