/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo2.webrender.ClientAnalyzerProcessor;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.UserInstance;
import nextapp.echo2.webrender.UserInstanceUpdateManager;
import nextapp.echo2.webrender.servermessage.ClientConfigurationUpdate;
import nextapp.echo2.webrender.servermessage.ClientPropertiesStore;
import nextapp.echo2.webrender.servermessage.ServerDelayMessageUpdate;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class SynchronizeService
implements Service {
    public static final String SERVICE_ID = "Echo.Synchronize";
    private Map clientMessagePartProcessorMap = new HashMap();

    public SynchronizeService() {
        this.registerClientMessagePartProcessor(new ClientAnalyzerProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream cleanXmlInputStream(InputStream in, String characterEncoding) throws IOException {
        ByteArrayOutputStream byteOut;
        block6: {
            byteOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            try {
                do {
                    if ((bytesRead = in.read(buffer)) <= 0) continue;
                    byteOut.write(buffer, 0, bytesRead);
                } while (bytesRead > 0);
                Object var7_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ex) {}
            in.close();
        }
        in.close();
        byte[] data = byteOut.toByteArray();
        data = new String(data, characterEncoding).trim().getBytes(characterEncoding);
        return new ByteArrayInputStream(data);
    }

    public String getId() {
        return SERVICE_ID;
    }

    public int getVersion() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parseRequestDocument(Connection conn) throws IOException {
        Document document;
        HttpServletRequest request = conn.getRequest();
        InputStream in = null;
        try {
            try {
                String userAgent = conn.getRequest().getHeader("user-agent");
                in = userAgent != null && userAgent.indexOf("onqueror") != -1 ? this.cleanXmlInputStream((InputStream)request.getInputStream(), conn.getUserInstance().getCharacterEncoding()) : request.getInputStream();
                document = DomUtil.getDocumentBuilder().parse(in);
                Object var7_8 = null;
                if (in == null) return document;
            }
            catch (SAXException ex) {
                throw new IOException("Provided InputStream cannot be parsed: " + ex);
            }
            catch (IOException ex) {
                throw new IOException("Provided InputStream cannot be parsed: " + ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ex) {
            // empty catch block
            return document;
        }
        in.close();
        return document;
    }

    protected void processClientMessage(Connection conn, Document clientMessageDocument) {
        UserInstance userInstance = conn.getUserInstance();
        Element[] messageParts = DomUtil.getChildElementsByTagName(clientMessageDocument.getDocumentElement(), "message-part");
        for (int i = 0; i < messageParts.length; ++i) {
            ClientMessagePartProcessor processor = (ClientMessagePartProcessor)this.clientMessagePartProcessorMap.get(messageParts[i].getAttribute("processor"));
            if (processor == null) {
                throw new RuntimeException("Invalid processor name \"" + messageParts[i].getAttribute("processor") + "\".");
            }
            processor.process(userInstance, messageParts[i]);
        }
    }

    protected void registerClientMessagePartProcessor(ClientMessagePartProcessor processor) {
        if (this.clientMessagePartProcessorMap.containsKey(processor.getName())) {
            throw new IllegalStateException("Processor already registered with name \"" + processor.getName() + "\".");
        }
        this.clientMessagePartProcessorMap.put(processor.getName(), processor);
    }

    protected abstract ServerMessage renderInit(Connection var1, Document var2);

    protected abstract ServerMessage renderUpdate(Connection var1, Document var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Connection conn) throws IOException {
        UserInstance userInstance;
        UserInstance userInstance2 = userInstance = conn.getUserInstance();
        synchronized (userInstance2) {
            ServerMessage serverMessage;
            Document clientMessageDocument = this.parseRequestDocument(conn);
            String messageType = clientMessageDocument.getDocumentElement().getAttribute("type");
            if ("initialize".equals(messageType)) {
                serverMessage = this.renderInit(conn, clientMessageDocument);
                ClientPropertiesStore.renderStoreDirective(serverMessage, userInstance.getClientProperties());
                ClientConfigurationUpdate.renderUpdateDirective(serverMessage, userInstance.getClientConfiguration());
                ServerDelayMessageUpdate.renderUpdateDirective(serverMessage, userInstance.getServerDelayMessage());
                serverMessage.getDocument().getDocumentElement().setAttribute("xml-attr-test", "x&y");
            } else {
                serverMessage = this.renderUpdate(conn, clientMessageDocument);
                this.processUserInstanceUpdates(userInstance, serverMessage);
            }
            serverMessage.setTransactionId(userInstance.getNextTransactionId());
            conn.setContentType(ContentType.TEXT_XML);
            serverMessage.render(conn.getWriter());
        }
    }

    private void processUserInstanceUpdates(UserInstance userInstance, ServerMessage serverMessage) {
        UserInstanceUpdateManager updateManager = userInstance.getUserInstanceUpdateManager();
        String[] updatedPropertyNames = updateManager.getPropertyUpdateNames();
        for (int i = 0; i < updatedPropertyNames.length; ++i) {
            if ("clientConfiguration".equals(updatedPropertyNames[i])) {
                ClientConfigurationUpdate.renderUpdateDirective(serverMessage, userInstance.getClientConfiguration());
                continue;
            }
            if (!"serverDelayMessage".equals(updatedPropertyNames[i])) continue;
            ServerDelayMessageUpdate.renderUpdateDirective(serverMessage, userInstance.getServerDelayMessage());
        }
        updateManager.purge();
    }

    public static interface ClientMessagePartProcessor {
        public String getName();

        public void process(UserInstance var1, Element var2);
    }
}

