/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.ape.Gender;
import ch.uzh.ifi.attempto.ape.LexiconEntry;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Individual
extends OntologyElement {
    private String word = "";
    private boolean hasDefiniteArticle = false;
    private List<Concept> conceptsCache;
    private long conceptsCacheStateID = -1L;

    @Override
    public String[] getWords() {
        if (this.hasDefiniteArticle) {
            return new String[]{"the " + this.word, this.word};
        }
        return new String[]{this.word, this.word};
    }

    @Override
    public String getHeadword() {
        return this.getPrettyWord(1);
    }

    @Override
    protected void changeWords(String ... stringArray) {
        if (stringArray.length == 1) {
            this.word = stringArray[0];
            this.hasDefiniteArticle = false;
        } else {
            this.word = stringArray[1];
            this.hasDefiniteArticle = stringArray[0].startsWith("the ");
        }
    }

    @Override
    List<LexiconEntry> getLexiconEntries() {
        ArrayList<LexiconEntry> arrayList = new ArrayList<LexiconEntry>();
        if (this.hasDefiniteArticle) {
            arrayList.add(LexiconEntry.createPropernameDefSgEntry((String)this.word, (String)this.word, (Gender)Gender.NEUTRAL));
        } else {
            arrayList.add(LexiconEntry.createPropernameSgEntry((String)this.word, (String)this.word, (Gender)Gender.NEUTRAL));
        }
        return arrayList;
    }

    @Override
    public String getType() {
        return "Proper Name";
    }

    @Override
    public String getInternalType() {
        return "propername";
    }

    public boolean hasDefiniteArticle() {
        return this.hasDefiniteArticle;
    }

    @Override
    public String getURISuffix() {
        return "#" + this.word;
    }

    public List<Concept> getConcepts() {
        Ontology ontology = this.getOntology();
        if (this.conceptsCacheStateID != ontology.getStateID()) {
            this.conceptsCache = ontology.getConcepts(this);
            this.conceptsCacheStateID = ontology.getStateID();
        }
        return new ArrayList<Concept>(this.conceptsCache);
    }

    public boolean areConceptsCached() {
        return this.conceptsCacheStateID == this.getOntology().getStateID();
    }
}

