/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.core.ontology;

import ch.uzh.ifi.attempto.acewiki.core.ontology.Role;
import ch.uzh.ifi.attempto.ape.LexiconEntry;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbRole
extends Role {
    private String thirdSg;
    private String inf;
    private String passive;

    @Override
    public String[] getWords() {
        return new String[]{this.thirdSg, this.inf, this.passive};
    }

    @Override
    protected void changeWords(String ... stringArray) {
        this.thirdSg = stringArray[0];
        this.inf = stringArray[1];
        this.passive = stringArray.length < 3 || stringArray[2] == null ? null : (stringArray[2].endsWith(" by") ? stringArray[2] : stringArray[2] + " by");
    }

    public String getPastPart() {
        String string = this.getWord(2);
        if (string == null) {
            return null;
        }
        if (string.endsWith(" by")) {
            return string.substring(0, string.length() - 3);
        }
        throw new RuntimeException("Illegal passive word form: " + string);
    }

    public String getPrettyPastPart() {
        String string = this.getWord(2);
        if (string == null) {
            return null;
        }
        if (string.endsWith(" by")) {
            return string.substring(0, string.length() - 3);
        }
        throw new RuntimeException("Illegal passive word form: " + string);
    }

    @Override
    List<LexiconEntry> getLexiconEntries() {
        ArrayList<LexiconEntry> arrayList = new ArrayList<LexiconEntry>();
        arrayList.add(LexiconEntry.createTrVerbThirdEntry((String)this.thirdSg, (String)this.inf));
        arrayList.add(LexiconEntry.createTrVerbInfEntry((String)this.inf, (String)this.inf));
        if (this.passive != null) {
            arrayList.add(LexiconEntry.createTrVerbPPEntry((String)this.getPastPart(), (String)this.inf));
        }
        return arrayList;
    }

    @Override
    public String getType() {
        return "Verb";
    }

    @Override
    public String getInternalType() {
        return "trverb";
    }
}

