/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui;

import ch.uzh.ifi.attempto.acewiki.Task;
import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.core.text.OntologyTextElement;
import ch.uzh.ifi.attempto.acewiki.gui.DropDownMenu;
import ch.uzh.ifi.attempto.acewiki.gui.ListItem;
import ch.uzh.ifi.attempto.acewiki.gui.WikiLink;
import ch.uzh.ifi.attempto.acewiki.gui.editor.SentenceEditorHandler;
import ch.uzh.ifi.attempto.acewiki.gui.page.ArticlePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.LogicPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.SentencePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.echocomp.DelayedComponent;
import ch.uzh.ifi.attempto.echocomp.HSpace;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.MessageWindow;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import ch.uzh.ifi.attempto.preditor.text.TextElement;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class TextRow
extends Column
implements ActionListener {
    private static final long serialVersionUID = -540135972060005725L;
    private Sentence sentence;
    private Wiki wiki;
    private WikiPage hostPage;
    private Row sentenceRow = new Row();
    private DropDownMenu dropDown;

    public TextRow(Sentence sentence, WikiPage wikiPage) {
        this.sentence = sentence;
        this.hostPage = wikiPage;
        this.wiki = wikiPage.getWiki();
        this.update();
    }

    private void update() {
        List<Individual> list;
        boolean bl;
        this.dropDown = this.sentence.isInferred() ? new DropDownMenu("light-blue", this) : (this.sentence.isReasonerParticipant() || this.sentence.isQuestion() ? new DropDownMenu("blue", this) : new DropDownMenu("red", this));
        if (!this.sentence.isIntegrated() && !this.sentence.isInferred()) {
            this.dropDown.addMenuEntry("Reassert");
            this.dropDown.addMenuSeparator();
        }
        if (!this.sentence.isInferred()) {
            this.dropDown.addMenuEntry("Edit...");
        }
        if (this.hostPage instanceof ArticlePage) {
            this.dropDown.addMenuEntry("Add...");
        }
        if (!this.sentence.isInferred()) {
            this.dropDown.addMenuEntry("Delete");
        }
        this.dropDown.addMenuSeparator();
        this.dropDown.addMenuEntry("Details");
        this.dropDown.addMenuEntry("Logic");
        Row row = new Row();
        Color color = Color.BLACK;
        boolean bl2 = bl = !this.sentence.isIntegrated() && !this.sentence.isInferred() && !this.sentence.isQuestion();
        if (bl) {
            color = new Color(193, 0, 0);
        }
        for (TextElement textElement : this.sentence.getTextElements()) {
            if (!textElement.getText().matches("[.?]") && row.getComponentCount() > 0) {
                row.add((Component)new HSpace());
            }
            if (textElement instanceof OntologyTextElement) {
                list = ((OntologyTextElement)textElement).getOntologyElement();
                if (list instanceof Individual && ((Individual)((Object)list)).hasDefiniteArticle()) {
                    SolidLabel solidLabel = new SolidLabel(textElement.getText().substring(0, 3));
                    solidLabel.setForeground(color);
                    row.add((Component)solidLabel);
                    row.add((Component)new HSpace());
                    row.add((Component)new WikiLink((OntologyElement)((Object)list), ((OntologyElement)((Object)list)).getPrettyWord(1), this.wiki, bl));
                    continue;
                }
                row.add((Component)new WikiLink((OntologyTextElement)textElement, this.wiki, bl));
                continue;
            }
            list = new SolidLabel(textElement.getText());
            list.setForeground(color);
            row.add((Component)list);
        }
        this.removeAll();
        this.sentenceRow.removeAll();
        this.sentenceRow.add((Component)this.dropDown);
        this.sentenceRow.add((Component)new HSpace(5));
        this.sentenceRow.add((Component)row);
        this.sentenceRow.add((Component)new HSpace(10));
        this.add((Component)this.sentenceRow);
        if (this.sentence.isQuestion() && this.hostPage instanceof ArticlePage) {
            Column column = new Column();
            column.setInsets(new Insets(20, 0, 0, 0));
            this.add((Component)column);
            if (this.sentence.isAnswerCached()) {
                TextElement textElement;
                textElement = new Column();
                list = this.sentence.getAnswer();
                if (list.size() > 0) {
                    Collections.sort(list);
                    for (Individual individual : list) {
                        Row row2 = new Row();
                        row2.add((Component)new ListItem(new Component[]{new WikiLink(individual, this.wiki)}));
                        textElement.add((Component)row2);
                    }
                } else {
                    textElement.add((Component)new SolidLabel("(no answer found)", 2, 10));
                }
                textElement.add((Component)new VSpace(4));
                column.add((Component)textElement);
            } else {
                column.add((Component)new DelayedComponent((Component)new Label((ImageReference)new ResourceImageReference("ch/uzh/ifi/attempto/acewiki/gui/img/wait.gif"))){
                    private static final long serialVersionUID = 7865984138467729544L;

                    public Component initComponent() {
                        Column column = new Column();
                        List<Individual> list = TextRow.this.sentence.getAnswer();
                        if (list.size() > 0) {
                            Collections.sort(list);
                            for (Individual individual : list) {
                                Row row = new Row();
                                row.add((Component)new ListItem(new Component[]{new WikiLink(individual, TextRow.this.wiki)}));
                                column.add((Component)row);
                            }
                        } else {
                            column.add((Component)new SolidLabel("(no answer found)", 2, 10));
                        }
                        column.add((Component)new VSpace(4));
                        return column;
                    }
                });
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Edit...")) {
            this.wiki.log("page", "dropdown: edit sentence: " + this.sentence.getText());
            ArticlePage articlePage = ArticlePage.create(this.sentence.getOwner(), this.wiki);
            this.wiki.showPage(articlePage);
            articlePage.edit(this.sentence);
        } else if (actionEvent.getActionCommand().equals("Add...")) {
            this.wiki.log("page", "dropdown: add sentence");
            this.wiki.showWindow((WindowPane)SentenceEditorHandler.generatePreditorAddWindow(this.sentence, (ArticlePage)this.hostPage));
        } else if (actionEvent.getActionCommand().equals("Delete")) {
            this.wiki.log("page", "dropdown: delete sentence: " + this.sentence.getText());
            this.wiki.showWindow((WindowPane)new MessageWindow("Delete", "Do you really want to delete this sentence?", null, (ActionListener)this, new String[]{"Yes", "No"}));
        } else if (actionEvent.getActionCommand().equals("Reassert")) {
            int n = this.sentence.reassert();
            if (n == 1) {
                this.wiki.showWindow((WindowPane)new MessageWindow("Conflict", "A sentence is in conflict with the current knowledge. For that reason, it cannot be added to the knowledge base.", new String[]{"OK"}));
            } else if (n == 2) {
                this.wiki.showWindow((WindowPane)new MessageWindow("Error", "A sentence could not be added to the knowledge base because the knowledge base got too complex.", new String[]{"OK"}));
            }
            if (this.sentence.isIntegrated()) {
                this.update();
            }
        } else if (actionEvent.getActionCommand().equals("Details")) {
            this.wiki.log("page", "dropdown: details sentence: " + this.sentence.getText());
            this.wiki.showPage(new SentencePage(this.wiki, this.sentence));
        } else if (actionEvent.getActionCommand().equals("Logic")) {
            this.wiki.log("page", "dropdown: logic sentence: " + this.sentence.getText());
            this.wiki.showPage(new LogicPage(this.wiki, this.sentence));
        } else if (actionEvent.getSource() instanceof MessageWindow && actionEvent.getActionCommand().equals("Yes")) {
            this.wiki.log("page", "dropdown: delete confirmed: " + this.sentence.getText());
            this.wiki.enqueueTaskShowingWaitWindow("Updating", "The sentence is being removed from the knowledge base...", new Task(){

                public void run() {
                    TextRow.this.sentence.getOwner().remove(TextRow.this.sentence);
                }

                public void updateGUI() {
                    TextRow.this.wiki.update();
                    TextRow.this.wiki.refresh();
                }
            });
        }
    }
}

