/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.editor;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.NounConcept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.gui.editor.FormPane;
import ch.uzh.ifi.attempto.acewiki.gui.editor.WordEditorWindow;
import ch.uzh.ifi.attempto.ape.FunctionWords;
import ch.uzh.ifi.attempto.echocomp.TextField;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionListener;

public class NounForm
extends FormPane {
    private static final long serialVersionUID = 172544159284997517L;
    private TextField singularField = new TextField();
    private TextField pluralField = new TextField();
    private NounConcept concept;
    private int wordNumber;

    public NounForm(NounConcept nounConcept, int n, WindowPane windowPane, Wiki wiki, ActionListener actionListener) {
        super(windowPane, wiki, actionListener);
        this.concept = nounConcept;
        this.wordNumber = n;
        this.setIconRow("concept", "Every noun represents a certain type of things. For example, the noun \"credit card\" stands for all things that are credit cards. Every noun has a singular form and a plural form.");
        this.addRow("singular", (Component)this.singularField, "examples: woman, credit card, process", true);
        this.addRow("plural", (Component)this.pluralField, "examples: women, credit cards, processes", true);
        this.singularField.setText(nounConcept.getPrettyWord(0));
        this.pluralField.setText(nounConcept.getPrettyWord(1));
        ApplicationInstance.getActive().setFocusedComponent((Component)this.singularField);
    }

    public static WordEditorWindow createCreatorWindow(int n, Wiki wiki, ActionListener actionListener) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createCreatorWindow();
        wordEditorWindow.addTab(new NounForm(new NounConcept(), n, wordEditorWindow, wiki, actionListener));
        return wordEditorWindow;
    }

    public static WordEditorWindow createEditorWindow(NounConcept nounConcept, Wiki wiki) {
        WordEditorWindow wordEditorWindow = WordEditorWindow.createEditorWindow();
        wordEditorWindow.addTab(new NounForm(nounConcept, 0, wordEditorWindow, wiki, wiki));
        return wordEditorWindow;
    }

    protected void save() {
        Wiki wiki = this.getWiki();
        String string = NounForm.normalize(this.singularField.getText());
        String string2 = NounForm.normalize(this.pluralField.getText());
        String string3 = string.replace("_", " ");
        String string4 = string2.replace("_", " ");
        if (string.equals(string2)) {
            wiki.log("edit", "error: singular and plural form have to be distinct.");
            this.showErrorMessage("Singular and plural form have to be distinct.");
            return;
        }
        if (string.equals("")) {
            wiki.log("edit", "error: no word defined");
            this.showErrorMessage("No singular form defined: Please specify the singular form.");
            return;
        }
        if (!NounForm.isValidString(string)) {
            wiki.log("edit", "error: word contains invalid character");
            this.showErrorMessage("Invalid character: Only a-z, A-Z, 0-9, -, and spaces are allowed, and the first character must be one of a-z A-Z.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string3 + "' is a predefined word and cannot be used here.");
            return;
        }
        OntologyElement ontologyElement = wiki.getOntology().get(string);
        if (ontologyElement != null && ontologyElement != this.concept) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string3 + "' is already used. Please use a different one.");
            return;
        }
        if (string2.equals("")) {
            wiki.log("edit", "error: no word defined");
            this.showErrorMessage("No plural form defined: Please specify the plural form.");
            return;
        }
        if (!NounForm.isValidString(string2)) {
            wiki.log("edit", "error: word contains invalid character");
            this.showErrorMessage("Invalid character: Only a-z, A-Z, 0-9, -, and spaces are allowed, and the first character must be one of a-z A-Z.");
            return;
        }
        if (FunctionWords.isFunctionWord((String)string2)) {
            wiki.log("edit", "error: word is predefined");
            this.showErrorMessage("'" + string4 + "' is a predefined word and cannot be used here.");
            return;
        }
        ontologyElement = wiki.getOntology().get(string2);
        if (ontologyElement != null && ontologyElement != this.concept) {
            wiki.log("edit", "error: word is already used");
            this.showErrorMessage("The word '" + string4 + "' is already used. Please use a different one.");
            return;
        }
        this.concept.setWords(string, string2);
        wiki.log("edit", "noun: " + string + " / " + string2);
        if (this.concept.getOntology() == null) {
            this.concept.registerAt(this.getWiki().getOntology());
        }
        this.finished(this.concept, this.wordNumber);
    }

    public String toString() {
        return "Noun";
    }
}

