/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Concept;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Individual;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Role;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.TextRow;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.editor.SentenceEditorHandler;
import ch.uzh.ifi.attempto.acewiki.gui.page.ConceptPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ReferencesPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.RolePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WordPage;
import ch.uzh.ifi.attempto.echocomp.SmallButton;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.WindowPane;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public abstract class ArticlePage
extends WikiPage
implements ActionListener {
    private Column textColumn = new Column();
    private SmallButton addButton = new SmallButton("add...", (ActionListener)this);

    protected ArticlePage(Wiki wiki, OntologyElement ontologyElement) {
        super(wiki, new Title(ontologyElement.getHeadword()));
        this.addSelectedTab("Article");
        this.addTab(ontologyElement.getType(), "Word", this);
        this.addTab("References", this);
        this.textColumn.setInsets(new Insets(10, 20, 0, 50));
        this.textColumn.setCellSpacing(new Extent(2));
        this.add((Component)this.textColumn);
    }

    public static ArticlePage create(OntologyElement ontologyElement, Wiki wiki) {
        if (ontologyElement instanceof Individual) {
            return new IndividualPage((Individual)ontologyElement, wiki);
        }
        if (ontologyElement instanceof Concept) {
            return new ConceptPage((Concept)ontologyElement, wiki);
        }
        if (ontologyElement instanceof Role) {
            return new RolePage((Role)ontologyElement, wiki);
        }
        return null;
    }

    public abstract OntologyElement getOntologyElement();

    public abstract void edit(Sentence var1);

    protected void doUpdate() {
        this.textColumn.removeAll();
        for (Sentence sentence : this.getOntologyElement().getSentences()) {
            this.textColumn.add((Component)new TextRow(sentence, this));
        }
        if (this.getOntologyElement().getSentences().size() == 0) {
            this.textColumn.add((Component)new SolidLabel("(article is empty)", 2, 10));
        }
        Row row = new Row();
        row.add((Component)this.addButton);
        this.textColumn.add((Component)row);
    }

    public boolean equals(Object object) {
        if (object instanceof ArticlePage) {
            return this.getOntologyElement() == ((ArticlePage)((Object)object)).getOntologyElement();
        }
        return false;
    }

    public String toString() {
        return this.getOntologyElement().getWord();
    }

    public boolean isExpired() {
        return !this.getWiki().getOntology().contains(this.getOntologyElement());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.log("page", "pressed: add");
            this.getWiki().showWindow((WindowPane)SentenceEditorHandler.generatePreditorAddWindow(null, this));
        } else if ("References".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: references");
            this.getWiki().showPage(new ReferencesPage(this));
        } else if ("Word".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: word");
            this.getWiki().showPage(new WordPage(this));
        }
    }
}

