/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.gui.IndexBar;
import ch.uzh.ifi.attempto.acewiki.gui.ListItem;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.WikiLink;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class IndexPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 6061966610996079528L;
    private static final int pageSize = 25;
    private String chosenChar = "A";
    private int chosenPage = 0;
    private ArrayList<OntologyElement> matchingElements;
    private Column indexColumn = new Column();
    private IndexBar letterIndexBar;
    private IndexBar numberIndexBar;

    public IndexPage(Wiki wiki) {
        super(wiki, new Title("Index", true));
        this.addTab("Main Page", this);
        this.addSelectedTab("Index");
        this.addTab("Search", this);
        this.add((Component)new VSpace(20));
        this.letterIndexBar = new IndexBar("First letter:", this);
        this.add((Component)this.letterIndexBar);
        this.numberIndexBar = new IndexBar("Page:", 0, this);
        this.add((Component)this.numberIndexBar);
        this.indexColumn.setInsets(new Insets(10, 5, 5, 20));
        this.indexColumn.setCellSpacing(new Extent(2));
        this.add((Component)this.indexColumn);
        this.update();
    }

    protected void doUpdate() {
        ArrayList<OntologyElement> arrayList = new ArrayList<OntologyElement>(this.getWiki().getOntologyElements());
        Collections.sort(arrayList);
        this.indexColumn.removeAll();
        this.matchingElements = new ArrayList();
        for (OntologyElement ontologyElement : arrayList) {
            if (!ontologyElement.getHeadword().toUpperCase().startsWith(this.chosenChar)) continue;
            this.matchingElements.add(ontologyElement);
        }
        if (this.matchingElements.size() == 0) {
            this.numberIndexBar.setVisible(false);
            this.indexColumn.add((Component)new SolidLabel("(no entry starting with '" + this.chosenChar + "')", 2, 10));
        } else {
            int n = (this.matchingElements.size() - 1) / 25 + 1;
            if (this.chosenPage > n) {
                this.chosenPage = 0;
            }
            this.numberIndexBar.setNumbers(n);
            this.numberIndexBar.setActiveButton(this.chosenPage);
            this.updatePage();
        }
    }

    private void updatePage() {
        this.indexColumn.removeAll();
        this.numberIndexBar.setVisible(this.matchingElements.size() > 25);
        int n = this.matchingElements.size();
        if (n > (this.chosenPage + 1) * 25) {
            n = (this.chosenPage + 1) * 25;
        }
        for (int i = this.chosenPage * 25; i < n; ++i) {
            this.indexColumn.add((Component)new ListItem(new Component[]{new WikiLink(this.matchingElements.get(i), this.getWiki())}));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.letterIndexBar) {
            this.chosenChar = actionEvent.getActionCommand();
            this.log("page", "pressed: first letter " + this.chosenChar);
            this.chosenPage = 0;
            this.update();
        } else if (actionEvent.getSource() == this.numberIndexBar) {
            this.chosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
            this.log("page", "pressed: page " + (this.chosenPage + 1));
            this.updatePage();
        } else if ("Main Page".equals(actionEvent.getActionCommand())) {
            this.getWiki().showStartPage();
        } else if ("Search".equals(actionEvent.getActionCommand())) {
            this.getWiki().showSearchPage();
        }
    }

    public boolean equals(Object object) {
        return object instanceof IndexPage;
    }

    public String toString() {
        return "-INDEX-";
    }
}

