/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.OntologyElement;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.IndexBar;
import ch.uzh.ifi.attempto.acewiki.gui.TextRow;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.WikiLink;
import ch.uzh.ifi.attempto.acewiki.gui.page.ArticlePage;
import ch.uzh.ifi.attempto.acewiki.gui.page.AssignmentsPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.ConceptPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.HierarchyPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.IndividualsPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.WordPage;
import ch.uzh.ifi.attempto.echocomp.SolidLabel;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import java.util.ArrayList;
import java.util.Collections;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class ReferencesPage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = 1025665226113017153L;
    private static final int pageSize = 15;
    private ArticlePage page;
    private Column referenceColumn = new Column();
    private IndexBar indexBar;
    private ArrayList<Sentence> sentences;
    private int chosenPage = 0;

    public ReferencesPage(ArticlePage articlePage) {
        super(articlePage.getWiki(), new Title(articlePage.getOntologyElement().getHeadword(), "- References"));
        this.page = articlePage;
        this.addTab("Article", this);
        this.addTab(articlePage.getOntologyElement().getType(), "Word", this);
        this.addSelectedTab("References");
        if (articlePage instanceof ConceptPage) {
            this.addTab("Individuals", this);
            this.addTab("Hierarchy", this);
        }
        if (articlePage instanceof IndividualPage) {
            this.addTab("Assignments", this);
        }
        this.add((Component)new VSpace(18));
        this.indexBar = new IndexBar("Page:", 0, this);
        this.add((Component)this.indexBar);
        this.referenceColumn.setInsets(new Insets(10, 2, 5, 20));
        this.referenceColumn.setCellSpacing(new Extent(2));
        this.add((Component)this.referenceColumn);
    }

    protected void doUpdate() {
        this.getTitle().setText(this.page.getOntologyElement().getHeadword());
        this.referenceColumn.removeAll();
        ArrayList<OntologyElement> arrayList = new ArrayList<OntologyElement>(this.getWiki().getOntologyElements());
        this.sentences = new ArrayList();
        Collections.sort(arrayList);
        for (OntologyElement ontologyElement : arrayList) {
            if (ontologyElement == this.page.getOntologyElement()) continue;
            for (Sentence sentence : ontologyElement.getSentences()) {
                if (!sentence.contains(this.page.getOntologyElement())) continue;
                this.sentences.add(sentence);
            }
        }
        if (this.sentences.size() == 0) {
            this.indexBar.setVisible(false);
            String string = this.page.getOntologyElement().getHeadword();
            this.referenceColumn.add((Component)new SolidLabel("(no other article refers to '" + (String)string + "')", 2, 10));
        } else {
            int n = (this.sentences.size() - 1) / 15 + 1;
            if (this.chosenPage > n) {
                this.chosenPage = 0;
            }
            this.indexBar.setNumbers(n);
            this.indexBar.setActiveButton(this.chosenPage);
            this.updatePage();
        }
    }

    public void updatePage() {
        this.referenceColumn.removeAll();
        this.indexBar.setVisible(this.sentences.size() > 15);
        int n = this.sentences.size();
        if (n > (this.chosenPage + 1) * 15) {
            n = (this.chosenPage + 1) * 15;
        }
        OntologyElement ontologyElement = null;
        for (int i = this.chosenPage * 15; i < n; ++i) {
            Row row;
            Sentence sentence = this.sentences.get(i);
            if (ontologyElement != sentence.getOwner()) {
                ontologyElement = sentence.getOwner();
                row = new Row();
                Column column = new Column();
                column.add((Component)new WikiLink(ontologyElement, this.getWiki()));
                Row row2 = new Row();
                row2.setBackground(Color.DARKGRAY);
                row2.setInsets(new Insets(0, 1, 0, 0));
                column.add((Component)row2);
                row.add((Component)column);
                this.referenceColumn.add((Component)new VSpace());
                this.referenceColumn.add((Component)row);
            }
            row = new Row();
            row.add((Component)new TextRow(sentence, this));
            this.referenceColumn.add((Component)row);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Wiki wiki = this.getWiki();
        if ("Article".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: article");
            wiki.showPage(this.page);
        } else if ("Word".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: word");
            wiki.showPage(new WordPage(this.page));
        } else if ("Individuals".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: individuals");
            wiki.showPage(new IndividualsPage((ConceptPage)this.page));
        } else if ("Hierarchy".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: hierarchy");
            wiki.showPage(new HierarchyPage((ConceptPage)this.page));
        } else if ("Assignments".equals(actionEvent.getActionCommand())) {
            this.log("page", "pressed: assignments");
            wiki.showPage(new AssignmentsPage((IndividualPage)this.page));
        } else if (actionEvent.getSource() == this.indexBar) {
            this.chosenPage = Integer.parseInt(actionEvent.getActionCommand()) - 1;
            this.log("page", "pressed: page " + (this.chosenPage + 1));
            this.updatePage();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ReferencesPage) {
            return this.page.equals((Object)((ReferencesPage)((Object)object)).page);
        }
        return false;
    }

    public boolean isExpired() {
        return this.page.isExpired();
    }

    public String toString() {
        return "-REF- " + this.page.getOntologyElement().getWord();
    }
}

