/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.acewiki.gui.page;

import ch.uzh.ifi.attempto.acewiki.Wiki;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Sentence;
import ch.uzh.ifi.attempto.acewiki.gui.Title;
import ch.uzh.ifi.attempto.acewiki.gui.page.LogicPage;
import ch.uzh.ifi.attempto.acewiki.gui.page.SyntaxBoxes;
import ch.uzh.ifi.attempto.acewiki.gui.page.WikiPage;
import ch.uzh.ifi.attempto.ape.OutputType;
import ch.uzh.ifi.attempto.echocomp.Label;
import ch.uzh.ifi.attempto.echocomp.VSpace;
import echopointng.DirectHtml;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class SentencePage
extends WikiPage
implements ActionListener {
    private static final long serialVersionUID = -1550505465878272821L;
    private Sentence sentence;

    public SentencePage(Wiki wiki, Sentence sentence) {
        super(wiki, new Title(sentence.toString(), false));
        this.sentence = sentence;
        this.addSelectedTab("Sentence");
        this.addTab("Logic", this);
        this.add((Component)new VSpace(15));
        this.addHeadline("Paraphrase");
        Column column = new Column();
        column.setInsets(new Insets(10, 5, 5, 15));
        column.add((Component)new Label(sentence.getParserResult().get(OutputType.PARAPHRASE1)));
        this.add((Component)column);
        this.addHeadline("Syntax Boxes");
        Column column2 = new Column();
        column2.setInsets(new Insets(10, 5, 5, 15));
        String string = sentence.getParserResult().get(OutputType.SYNTAX);
        column2.add((Component)new DirectHtml(SyntaxBoxes.getBoxesHtml(string, true, true, true)));
        this.add((Component)column2);
        this.addHeadline("Syntax Tree");
        Column column3 = new Column();
        column3.setInsets(new Insets(10, 0, 5, 15));
        column3.add((Component)new DirectHtml("<pre>" + sentence.getParserResult().get(OutputType.SYNTAXPP) + "</pre>"));
        this.add((Component)column3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Logic".equals(actionEvent.getActionCommand())) {
            this.getWiki().showPage(new LogicPage(this.getWiki(), this.sentence));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SentencePage) {
            return this.sentence == ((SentencePage)((Object)object)).sentence;
        }
        return false;
    }

    public String toString() {
        return this.sentence.getText();
    }
}

