/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.ExtentEx;
import echopointng.MutableStyleEx;
import echopointng.model.ColorSelectionModel;
import echopointng.model.ColorSwatchModel;
import echopointng.model.DefaultColorSelectionModel;
import echopointng.model.WebSafeColorSwatchModel;
import echopointng.util.ColorKit;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class ColorChooser
extends AbleComponent {
    public static final Style DEFAULT_STYLE;
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTY_SELECTION_TEXT = "selectionText";
    public static final String PROPERTY_SWATCH_HEIGHT = "swatchHeight";
    public static final String PROPERTY_SWATCH_MODEL = "swatchModel";
    public static final String PROPERTY_SWATCH_WIDTH = "swatchWidth";
    public static final String PROPERTY_SWATCHES_PER_ROW = "swatchesPerRow";
    private ChangeListener internalListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            ColorChooser.this.firePropertyChange("selectedColor", null, ColorChooser.this.getSelectedColor());
        }
    };

    public ColorChooser() {
        this.setSelectionModel(new DefaultColorSelectionModel());
    }

    public Color getSelectedColor() {
        if (this.getSelectionModel() != null) {
            return this.getSelectionModel().getSelectedColor();
        }
        return null;
    }

    public ColorSelectionModel getSelectionModel() {
        return (ColorSelectionModel)this.getProperty(PROPERTY_SELECTION_MODEL);
    }

    public String getSelectionText() {
        return (String)this.getProperty(PROPERTY_SELECTION_TEXT);
    }

    public int getSwatchesPerRow() {
        return this.getProperty(PROPERTY_SWATCHES_PER_ROW, 17);
    }

    public Extent getSwatchHeight() {
        return (Extent)this.getProperty(PROPERTY_SWATCH_HEIGHT);
    }

    public ColorSwatchModel getSwatchModel() {
        return (ColorSwatchModel)this.getProperty(PROPERTY_SWATCH_MODEL);
    }

    public Extent getSwatchWidth() {
        return (Extent)this.getProperty(PROPERTY_SWATCH_WIDTH);
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if ("click".equals(inputName)) {
            this.setSelectedColor(ColorKit.makeColor((String)inputValue));
        }
    }

    public void setSelectedColor(Color newValue) {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().setSelectedColor(newValue);
        }
    }

    public void setSelectionModel(ColorSelectionModel newValue) {
        ColorSelectionModel oldValue = this.getSelectionModel();
        if (oldValue != null) {
            oldValue.removeListener(this.internalListener);
        }
        if (newValue != null) {
            newValue.addListener(this.internalListener);
        }
        this.setProperty(PROPERTY_SELECTION_MODEL, newValue);
    }

    public void setSelectionText(String newValue) {
        this.setProperty(PROPERTY_SELECTION_TEXT, newValue);
    }

    public void setSwatchesPerRow(int newValue) {
        this.setProperty(PROPERTY_SWATCHES_PER_ROW, newValue);
    }

    public void setSwatchHeight(Extent newValue) {
        this.setProperty(PROPERTY_SWATCH_HEIGHT, newValue);
    }

    public void setSwatchModel(ColorSwatchModel newValue) {
        this.setProperty(PROPERTY_SWATCH_MODEL, newValue);
    }

    public void setSwatchWidth(Extent newValue) {
        this.setProperty(PROPERTY_SWATCH_WIDTH, newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", (Object)new BorderEx(ColorKit.clr("#317082")));
        style.setProperty("insets", new Insets((Extent)new ExtentEx(1)));
        style.setProperty(PROPERTY_SELECTION_TEXT, "Selected : ");
        style.setProperty(PROPERTY_SWATCHES_PER_ROW, 17);
        style.setProperty(PROPERTY_SWATCH_HEIGHT, (Object)new ExtentEx(10));
        style.setProperty(PROPERTY_SWATCH_WIDTH, (Object)new ExtentEx(10));
        style.setProperty(PROPERTY_SWATCH_MODEL, new WebSafeColorSwatchModel());
        DEFAULT_STYLE = style;
    }
}

