/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.MutableStyleEx;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class ImageMap
extends AbleComponent {
    public static final String PROPERTY_IMAGE = "image";
    public static final Style DEFAULT_STYLE;
    private Map coordMap = new HashMap();

    public ImageMap() {
        this(null);
    }

    public ImageMap(ImageReference image) {
        this.setImage(image);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)l);
    }

    public void addCoord(Coords coord) {
        this.coordMap.put(coord.getActionCommand(), coord);
    }

    public void addCoord(Coords coord, String actionCommand) {
        coord.setActionCommand(actionCommand);
        this.coordMap.put(coord.getActionCommand(), coord);
    }

    public void processInput(String inputName, Object inputValue) {
        this.fireActionPerformed(new ActionEvent((Object)this, inputName));
    }

    public void fireActionPerformed(ActionEvent e) {
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((ActionListener)listeners[index]).actionPerformed(e);
        }
    }

    public Set getCoords() {
        return this.coordMap.entrySet();
    }

    public ImageReference getImage() {
        return (ImageReference)this.getProperty(PROPERTY_IMAGE);
    }

    public void removeActionListener(ActionListener l) {
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)l);
    }

    public void setImage(ImageReference newValue) {
        this.setProperty(PROPERTY_IMAGE, newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", (Object)new BorderEx(0, null, 0));
        style.setProperty("mouseCursor", 3);
        DEFAULT_STYLE = style;
    }

    public static class Coords
    implements Serializable {
        public static final int RECTANGLE = 0;
        public static final int CIRCLE = 1;
        public static final int POLYGON = 2;
        private int type;
        private int top;
        private int bottom;
        private int left;
        private int right;
        private int x;
        private int y;
        private int radius;
        private int[] polyCoords;
        private String actionCommand = null;
        private String altText = null;

        public Coords(int left, int top, int right, int bottom) {
            this(left, top, right, bottom, null);
        }

        public Coords(int left, int top, int right, int bottom, String actionCommand) {
            this.type = 0;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.actionCommand = actionCommand;
        }

        public Coords(int x, int y, int radius) {
            this(x, y, radius, null);
        }

        public Coords(int x, int y, int radius, String actionCommand) {
            this.type = 1;
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.actionCommand = actionCommand;
        }

        public Coords(int[] polyCoords) {
            this(polyCoords, null);
        }

        public Coords(int[] polyCoords, String actionCommand) {
            this.type = 2;
            this.polyCoords = polyCoords;
            this.actionCommand = actionCommand;
        }

        public String getActionCommand() {
            return this.actionCommand;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getTop() {
            return this.top;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getRadius() {
            return this.radius;
        }

        public int[] getPolygonCoords() {
            return this.polyCoords;
        }

        public int getType() {
            return this.type;
        }

        public void setActionCommand(String newActionCommand) {
            this.actionCommand = newActionCommand;
        }

        public String getAltText() {
            return this.altText;
        }

        public void setAltText(String altText) {
            this.altText = altText;
        }
    }
}

