/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssObjectDeclarationParser;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.propertypeer.AbstractCssPropertyPeer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Alignment;

public class AlignmentPeer
extends AbstractCssPropertyPeer {
    private static final Map HORIZONTAL_CONSTANTS;
    private static final Map VERTICAL_CONSTANTS;

    protected Class getConversionClass() {
        return Alignment.class;
    }

    protected boolean canConvert(CssObjectIntrospector ci, String propertyValue) {
        if (AlignmentPeer.isNullString(propertyValue)) {
            return true;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (tokens.length == 3 && tokens[0].equalsIgnoreCase("alignment")) {
            String h = tokens[1].trim().toUpperCase();
            String v = tokens[2].trim().toUpperCase();
            return HORIZONTAL_CONSTANTS.containsKey(h) && VERTICAL_CONSTANTS.containsKey(v);
        }
        return false;
    }

    protected Object getObject(CssObjectIntrospector ci, String propertyValue) {
        if (AlignmentPeer.isNullString(propertyValue)) {
            return null;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        String hs = tokens[1].trim().toUpperCase();
        String vs = tokens[2].trim().toUpperCase();
        int ha = 0;
        int va = 0;
        if (HORIZONTAL_CONSTANTS.containsKey(hs)) {
            ha = (Integer)HORIZONTAL_CONSTANTS.get(hs);
        }
        if (VERTICAL_CONSTANTS.containsKey(vs)) {
            va = (Integer)VERTICAL_CONSTANTS.get(vs);
        }
        return new Alignment(ha, va);
    }

    protected String getString(CssObjectIntrospector ci, Object object) {
        Alignment value = (Alignment)object;
        StringBuffer sb = new StringBuffer();
        sb.append("alignment(");
        sb.append(AlignmentPeer.getConstantFromMap(HORIZONTAL_CONSTANTS, value.getHorizontal()));
        sb.append(",");
        sb.append(AlignmentPeer.getConstantFromMap(VERTICAL_CONSTANTS, value.getVertical()));
        sb.append(")");
        return sb.toString();
    }

    static {
        HashMap<String, Integer> constantMap = new HashMap<String, Integer>();
        constantMap.put("LEADING", new Integer(1));
        constantMap.put("TRAILING", new Integer(2));
        constantMap.put("LEFT", new Integer(3));
        constantMap.put("CENTER", new Integer(4));
        constantMap.put("RIGHT", new Integer(5));
        HORIZONTAL_CONSTANTS = Collections.unmodifiableMap(constantMap);
        constantMap = new HashMap();
        constantMap.put("TOP", new Integer(6));
        constantMap.put("CENTER", new Integer(4));
        constantMap.put("BOTTOM", new Integer(7));
        VERTICAL_CONSTANTS = Collections.unmodifiableMap(constantMap);
    }
}

