/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssObjectDeclarationParser;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.propertypeer.AbstractCssPropertyPeer;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.HttpImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;

public class ImageReferencePeer
extends AbstractCssPropertyPeer {
    protected Class getConversionClass() {
        return ImageReference.class;
    }

    protected boolean canConvert(CssObjectIntrospector ci, String propertyValue) {
        if (ImageReferencePeer.isNullString(propertyValue)) {
            return true;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (tokens[0].equalsIgnoreCase("image") || tokens[0].equalsIgnoreCase("img")) {
            if (tokens.length != 2 && tokens.length != 4) {
                return false;
            }
            if (tokens.length == 4) {
                return ImageReferencePeer.isExtent(tokens[2]) && ImageReferencePeer.isExtent(tokens[3]);
            }
            return true;
        }
        if (tokens[0].indexOf("resimage(") == 0 || tokens[0].indexOf("resimg(") == 0) {
            if (tokens.length != 2 && tokens.length != 3 && tokens.length != 5) {
                return false;
            }
            if (tokens.length == 5) {
                return ImageReferencePeer.isExtent(tokens[3]) && ImageReferencePeer.isExtent(tokens[4]);
            }
            return true;
        }
        return false;
    }

    protected Object getObject(CssObjectIntrospector ci, String propertyValue) {
        if (ImageReferencePeer.isNullString(propertyValue)) {
            return null;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (tokens[0].equalsIgnoreCase("image") || tokens[0].equalsIgnoreCase("img")) {
            if (tokens.length == 4) {
                return ImageReferencePeer.getHttpImageRef(tokens[1].trim(), tokens[2].trim(), tokens[3].trim());
            }
            return ImageReferencePeer.getHttpImageRef(tokens[1].trim(), null, null);
        }
        if (tokens.length == 5) {
            return this.getResImageRef(tokens[1].trim(), tokens[2].trim(), tokens[3].trim(), tokens[4].trim());
        }
        if (tokens.length == 3) {
            return this.getResImageRef(tokens[1].trim(), tokens[2].trim(), null, null);
        }
        return this.getResImageRef(tokens[1].trim(), null, null, null);
    }

    protected String getString(CssObjectIntrospector ci, Object object) {
        ImageReference value = (ImageReference)object;
        StringBuffer sb = new StringBuffer();
        if (value instanceof HttpImageReference) {
            sb.append("image(");
            sb.append("'");
            sb.append(((HttpImageReference)value).getUri());
            sb.append("'");
        } else if (value instanceof ResourceImageReference) {
            sb.append("resimage('");
            sb.append("'");
            sb.append(((ResourceImageReference)value).getResource());
            sb.append("'");
            sb.append(",");
            sb.append(((ResourceImageReference)value).getContentType());
        } else {
            sb.append("'");
            sb.append("??? unhandled image reference type");
            sb.append("'");
        }
        if (value.getWidth() != null && value.getHeight() != null) {
            sb.append(",");
            sb.append(value.getWidth());
            sb.append(",");
            sb.append(value.getHeight());
        }
        sb.append(")");
        return sb.toString();
    }

    private static HttpImageReference getHttpImageRef(String uri, String width, String height) {
        String theUri = uri.trim();
        if (ImageReferencePeer.isNullString(uri)) {
            theUri = null;
        }
        if (width != null && height != null) {
            Extent w = ImageReferencePeer.makeExtent(width);
            Extent h = ImageReferencePeer.makeExtent(height);
            return new HttpImageReference(theUri, w, h);
        }
        return new HttpImageReference(theUri);
    }

    private ResourceImageReference getResImageRef(String uri, String contentType, String width, String height) {
        String theUri = uri.trim();
        if (ImageReferencePeer.isNullString(uri)) {
            theUri = null;
        }
        if (width != null && height != null) {
            Extent w = ImageReferencePeer.makeExtent(width);
            Extent h = ImageReferencePeer.makeExtent(height);
            return new ResourceImageReference(theUri, contentType, w, h);
        }
        if (contentType != null) {
            return new ResourceImageReference(theUri, contentType);
        }
        return new ResourceImageReference(theUri);
    }
}

