/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nextapp.echo2.app.event.TableModelEvent;
import nextapp.echo2.app.event.TableModelListener;
import nextapp.echo2.app.table.AbstractTableModel;
import nextapp.echo2.app.table.TableModel;

public class ColumnHidingTableModel
extends AbstractTableModel {
    private TableModelListener forwarderModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            TableModelEvent newEvent = new TableModelEvent((TableModel)ColumnHidingTableModel.this, ColumnHidingTableModel.this.mapColumnToUnderlyingModel(e.getColumn()), e.getFirstRow(), e.getLastRow(), e.getType());
            ColumnHidingTableModel.this.fireTableChanged(newEvent);
        }
    };
    private TableModel underlyingTableModel;
    private Set hiddenColumnsSet;

    public ColumnHidingTableModel(TableModel underlyingTableModel) {
        if (underlyingTableModel == null) {
            throw new IllegalArgumentException("The underlying TableModel must not be null");
        }
        this.underlyingTableModel = underlyingTableModel;
        underlyingTableModel.addTableModelListener(this.forwarderModelListener);
        this.hiddenColumnsSet = new HashSet();
    }

    public TableModel getUnderlyingTableModel() {
        return this.underlyingTableModel;
    }

    public int getColumnCount() {
        int baseColumnCount = this.underlyingTableModel.getColumnCount();
        int hiddenColumnsCount = this.hiddenColumnsSet.size();
        return baseColumnCount - hiddenColumnsCount;
    }

    public Object getValueAt(int column, int row) {
        int mappedColumn = this.mapColumnToUnderlyingModel(column);
        return this.underlyingTableModel.getValueAt(mappedColumn, row);
    }

    public Class getColumnClass(int column) {
        int mappedColumn = this.mapColumnToUnderlyingModel(column);
        return super.getColumnClass(mappedColumn);
    }

    public String getColumnName(int column) {
        int mappedColumn = this.mapColumnToUnderlyingModel(column);
        return super.getColumnName(mappedColumn);
    }

    private int mapColumnToUnderlyingModel(int column) {
        int offset = 0;
        int matchColumn = 0;
        int baseColumnCount = this.underlyingTableModel.getColumnCount();
        for (int i = 0; i < baseColumnCount; ++i) {
            if (this.isHiddenColumn(i)) {
                ++offset;
                continue;
            }
            if (++matchColumn > column) break;
        }
        int mappedColumn = column + offset;
        return mappedColumn;
    }

    public int getRowCount() {
        return this.underlyingTableModel.getRowCount();
    }

    public int[] getHiddenColumns() {
        int[] hiddenColumnsArr = new int[this.hiddenColumnsSet.size()];
        int index = 0;
        Iterator iter = this.hiddenColumnsSet.iterator();
        while (iter.hasNext()) {
            hiddenColumnsArr[index++] = (Integer)iter.next();
        }
        Arrays.sort(hiddenColumnsArr);
        return hiddenColumnsArr;
    }

    public boolean isHiddenColumn(int column) {
        return this.hiddenColumnsSet.contains(new Integer(column));
    }

    public void hideColumn(int column) {
        this.hideColumnImpl(column, true);
    }

    public void showColumn(int column) {
        this.hideColumnImpl(column, false);
    }

    public void toggleColumn(int column) {
        this.hideColumnImpl(column, !this.isHiddenColumn(column));
    }

    private void hideColumnImpl(int column, boolean hideFlag) {
        int maxColumn = this.underlyingTableModel.getColumnCount();
        if (column < 0 || column >= maxColumn) {
            throw new IllegalArgumentException("The column index must be >= 0 || < " + maxColumn);
        }
        if (hideFlag) {
            this.hiddenColumnsSet.add(new Integer(column));
        } else {
            this.hiddenColumnsSet.remove(new Integer(column));
        }
        this.fireTableStructureChanged();
    }

    public void showAllColumns() {
        this.hiddenColumnsSet = new HashSet();
        this.fireTableStructureChanged();
    }
}

