/*
 * Decompiled with CFR 0.152.
 */
package echopointng.treetable;

import echopointng.tree.TreeModelEvent;
import echopointng.tree.TreeModelListener;
import echopointng.tree.TreeNode;
import echopointng.tree.TreePath;
import echopointng.treetable.TreeTableModel;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.event.EventListenerList;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    public static final Class hierarchicalColumnClass = TreeTableModel.class;
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();
    protected HashMap nodeIds = new HashMap();
    private int nextNodeId = 0;

    public AbstractTreeTableModel() {
        this(null);
    }

    public AbstractTreeTableModel(Object root) {
        this.root = root;
    }

    public Class getColumnClass(int column) {
        return column == 0 ? hierarchicalColumnClass : Object.class;
    }

    public String getColumnName(int column) {
        return "Column " + column;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        try {
            return ((TreeNode)parent).getChildAt(index);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public Object getParent(Object child) {
        return null;
    }

    public int getChildCount(Object parent) {
        try {
            return ((TreeNode)parent).getChildCount();
        }
        catch (ClassCastException ex) {
            return 0;
        }
    }

    public int getColumnCount() {
        return 1;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        try {
            int index = ((TreeNode)parent).getIndex((TreeNode)child);
            if (index >= 0) {
                return index;
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        if (node == null) {
            return false;
        }
        try {
            return ((TreeNode)node).isLeaf();
        }
        catch (ClassCastException ex) {
            return this.getChildCount(node) == 0;
        }
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public Object[] getPathToRoot(Object node) {
        return this.getPathToRoot((TreeNode)node, 0);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.addListener(TreeModelListener.class, (EventListener)l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.removeListener(TreeModelListener.class, (EventListener)l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (listeners[i] != (class$echopointng$tree$TreeModelListener == null ? AbstractTreeTableModel.class$("echopointng.tree.TreeModelListener") : class$echopointng$tree$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (listeners[i] != (class$echopointng$tree$TreeModelListener == null ? AbstractTreeTableModel.class$("echopointng.tree.TreeModelListener") : class$echopointng$tree$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (listeners[i] != (class$echopointng$tree$TreeModelListener == null ? AbstractTreeTableModel.class$("echopointng.tree.TreeModelListener") : class$echopointng$tree$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (listeners[i] != (class$echopointng$tree$TreeModelListener == null ? AbstractTreeTableModel.class$("echopointng.tree.TreeModelListener") : class$echopointng$tree$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public String getNodeId(Object node) {
        Integer nodeId = (Integer)this.nodeIds.get(node);
        if (nodeId == null) {
            nodeId = new Integer(this.nextNodeId++);
            this.nodeIds.put(node, nodeId);
        }
        return String.valueOf(nodeId);
    }

    public Object getNodeById(String id) {
        Iterator iter = this.nodeIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!String.valueOf(entry.getValue()).equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }
}

