/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.ButtonEx;
import echopointng.EPNG;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.ui.util.TriCellTable;
import echopointng.util.HtmlKit;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.FocusSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.WindowUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ButtonExPeer
extends AbstractEchoPointPeer
implements ActionProcessor,
FocusSupport {
    public static final Service BUTTON_SERVICE = JavaScriptService.forResource((String)"EPNG.ButtonEx", (String)"/echopointng/ui/resource/js/button.js");

    public void renderSetFocus(RenderContext rc, Component component) {
        WindowUpdate.renderSetFocus((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)component));
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String value = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "input_click", (Object)Integer.valueOf(value));
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(BUTTON_SERVICE.getId());
        this.createDisposeDirective(serverMessage, component);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        return super.renderUpdateBaseImpl(rc, update, targetId, true);
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(BUTTON_SERVICE);
        ButtonEx button = (ButtonEx)component;
        String id = ContainerInstance.getElementId((Component)button);
        Element topElement = this.getTopLevelButtonElement(rc, button, fallbackStyle);
        topElement.setAttribute("id", id);
        rc.addStandardWebSupport(topElement);
        CssStyle cssStyle = this.renderTopLevelStyleSupport(rc, button, fallbackStyle);
        topElement.setAttribute("style", cssStyle.renderInline());
        this.renderButtonContent(rc, topElement, button, fallbackStyle);
        parent.appendChild(topElement);
        boolean addRolloverListener = false;
        if (button.isRenderEnabled()) {
            addRolloverListener = this.renderRolloverStyleSupport(rc, button, fallbackStyle);
        }
        this.createInitDirective(rc, button, fallbackStyle, addRolloverListener);
    }

    protected Element getTopLevelButtonElement(RenderingContext rc, ButtonEx button, Style fallbackStyle) {
        return rc.createE("div");
    }

    protected CssStyle renderTopLevelStyleSupport(RenderingContext rc, ButtonEx button, Style fallbackStyle) {
        CssStyleEx cssStyle = new CssStyleEx((Component)button, fallbackStyle);
        Render.asFillImage(cssStyle, (Component)button, "backgroundImage", fallbackStyle, rc);
        if (!button.isRenderEnabled()) {
            Render.asColors(cssStyle, (Component)button, "disabledBackground", "disabledForeground", fallbackStyle);
            Render.asFont(cssStyle, (Component)button, "disabledFont", fallbackStyle);
            Render.asBorder(cssStyle, (Component)button, "disabledBorder", fallbackStyle);
            Render.asFillImage(cssStyle, (Component)button, "disabledBackgroundImage", fallbackStyle, rc);
        }
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            cssStyle.setAttribute("white-space", "nowrap");
        }
        return cssStyle;
    }

    protected boolean renderRolloverStyleSupport(RenderingContext rc, ButtonEx button, Style fallbackStyle) {
        String id = ContainerInstance.getElementId((Component)button);
        boolean enabled = button.isRenderEnabled();
        FillImage backgroundImage = (FillImage)rc.getRP(enabled ? "backgroundImage" : "disabledBackgroundImage", fallbackStyle);
        boolean rolloverEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false);
        boolean pressedEnabled = rc.getRP("pressedEnabled", fallbackStyle, false);
        boolean addRolloverListener = false;
        if (enabled && (rolloverEnabled || pressedEnabled)) {
            ImageReference icon = (ImageReference)rc.getRP(enabled ? "icon" : "disabledIcon", fallbackStyle);
            boolean hasIcon = icon != null;
            CssStyle baseCssStyle = this.renderTopLevelStyleSupport(rc, button, fallbackStyle);
            rc.renderSetProperty(id, "defaultStyle", baseCssStyle.renderInline());
            if (hasIcon) {
                rc.renderSetProperty(id, "defaultIcon", ImageManager.getURI(rc, icon));
            }
            if (rolloverEnabled) {
                ImageReference rolloverIcon;
                CssStyle rolloverCssStyle = new CssStyle();
                Render.asBorder(rolloverCssStyle, (Component)button, "rolloverBorder", fallbackStyle);
                Render.asColors(rolloverCssStyle, (Component)button, "rolloverBackground", "rolloverForeground", fallbackStyle);
                Render.asFont(rolloverCssStyle, (Component)button, "rolloverFont", fallbackStyle);
                if (!rc.getRP("lineWrap", fallbackStyle, false)) {
                    rolloverCssStyle.setAttribute("white-space", "nowrap");
                }
                if (backgroundImage != null) {
                    Render.asFillImage(rolloverCssStyle, (Component)button, "rolloverBackgroundImage", fallbackStyle, rc);
                }
                if (rolloverCssStyle.hasAttributes()) {
                    rc.renderSetProperty(id, "rolloverStyle", rolloverCssStyle.renderInline());
                    addRolloverListener = true;
                }
                if (hasIcon && (rolloverIcon = (ImageReference)rc.getRP("rolloverIcon", fallbackStyle)) != null) {
                    rc.renderSetProperty(id, "rolloverIcon", ImageManager.getURI(rc, rolloverIcon));
                }
            }
            if (pressedEnabled) {
                ImageReference pressedIcon;
                CssStyle pressedCssStyle = new CssStyle();
                Render.asBorder(pressedCssStyle, (Component)button, "pressedBorder", fallbackStyle);
                Render.asColors(pressedCssStyle, (Component)button, "pressedBackground", "pressedForeground", fallbackStyle);
                Render.asFont(pressedCssStyle, (Component)button, "pressedFont", fallbackStyle);
                if (!rc.getRP("lineWrap", fallbackStyle, false)) {
                    pressedCssStyle.setAttribute("white-space", "nowrap");
                }
                if (backgroundImage != null) {
                    Render.asFillImage(pressedCssStyle, (Component)button, "pressedBackgroundImage", fallbackStyle, rc);
                }
                if (pressedCssStyle.hasAttributes()) {
                    rc.renderSetProperty(id, "pressedStyle", pressedCssStyle.renderInline());
                }
                if (hasIcon && (pressedIcon = (ImageReference)rc.getRP("pressedIcon", fallbackStyle)) != null) {
                    rc.renderSetProperty(id, "pressedIcon", ImageManager.getURI(rc, pressedIcon));
                }
            }
        }
        return addRolloverListener;
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPButton.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void createInitDirective(RenderingContext rc, ButtonEx buttonEx, Style fallbackStyle, boolean addRolloverListener) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPButton.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("enabled", String.valueOf(buttonEx.isRenderEnabled()));
        itemElement.setAttribute("serverNotify", String.valueOf(buttonEx.hasActionListeners()));
        if (buttonEx.isRenderEnabled()) {
            this.renderEventSupport(rc, itemElement, buttonEx, addRolloverListener);
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void renderEventSupport(RenderingContext rc, Element itemXML, ButtonEx button, boolean addRolloverListener) {
        boolean pressedEnabled = rc.getRP("pressedEnabled", false);
        itemXML.setAttribute("event-click", String.valueOf(true));
        if (addRolloverListener) {
            itemXML.setAttribute("event-mouseover", String.valueOf(true));
            itemXML.setAttribute("event-mouseout", String.valueOf(true));
        }
        if (pressedEnabled) {
            itemXML.setAttribute("event-mousedown", String.valueOf(true));
            itemXML.setAttribute("event-mouseup", String.valueOf(true));
        }
    }

    protected void renderButtonContent(RenderingContext rc, Element buttonContainerElement, ButtonEx button, Style fallbackStyle) {
        Element iconElement;
        Node contentNode = null;
        String elementId = ContainerInstance.getElementId((Component)button);
        ImageReference icon = (ImageReference)rc.getRP(button.isRenderEnabled() ? "icon" : "disabledIcon", fallbackStyle);
        Object text = rc.getRP("text", fallbackStyle);
        Node[] textNodes = null;
        if (text instanceof String) {
            int newLinePolicy = 0;
            if (rc.getRP("interpretNewlines", fallbackStyle, false)) {
                newLinePolicy = 2;
            }
            textNodes = HtmlKit.encodeNewLines(rc.getDocument(), (String)text, newLinePolicy);
        } else if (text instanceof XhtmlFragment) {
            XhtmlFragment fragment = (XhtmlFragment)text;
            try {
                textNodes = fragment.toDOM(rc.getDocument());
            }
            catch (Exception e) {
                throw new RuntimeException("The XhtmlFragment is not valid XHTML : " + fragment.getFragment(), e);
            }
        }
        if (icon == null) {
            iconElement = null;
        } else {
            iconElement = ImageManager.createImgE(rc, icon);
            iconElement.setAttribute("id", elementId + "_icon");
        }
        int entityCount = (textNodes == null ? 0 : 1) + (iconElement == null ? 0 : 1);
        switch (entityCount) {
            case 1: {
                if (textNodes != null) {
                    contentNode = rc.getDocument().createDocumentFragment();
                    for (int i = 0; i < textNodes.length; ++i) {
                        contentNode.appendChild(textNodes[i]);
                    }
                    break;
                }
                contentNode = iconElement;
                break;
            }
            case 2: {
                Extent iconTextMargin = (Extent)rc.getRP("iconTextMargin", fallbackStyle);
                Alignment textPosition = (Alignment)rc.getRP("textPosition", fallbackStyle);
                int orientation = this.convertIconTextPositionToOrientation(textPosition, (Component)button);
                TriCellTable tct = new TriCellTable(rc.getDocument(), elementId, orientation, iconTextMargin);
                this.renderCellText(rc, tct, textNodes, button, fallbackStyle);
                this.renderCellIcon(tct, iconElement, 1, fallbackStyle);
                Element tableElement = tct.getTableElement();
                tableElement.setAttribute("id", elementId + "_table");
                tableElement.setAttribute("style", "width:100%;height:100%");
                contentNode = tableElement;
                break;
            }
            default: {
                contentNode = null;
            }
        }
        if (contentNode != null) {
            buttonContainerElement.appendChild(contentNode);
        }
    }

    protected void renderCellIcon(TriCellTable tct, Element iconElement, int cellIndex, Style fallbackStyle) {
        Element iconTdElement = tct.getTdElement(cellIndex);
        iconTdElement.setAttribute("style", "padding: 0px");
        iconTdElement.appendChild(iconElement);
    }

    protected void renderCellText(RenderingContext rc, TriCellTable tct, Node[] textNodes, ButtonEx button, Style fallbackStyle) {
        Element textTdElement = tct.getTdElement(0);
        CssStyle textTdCssStyle = new CssStyle();
        textTdCssStyle.setAttribute("padding", "0px");
        textTdCssStyle.setAttribute("width", "100%");
        AlignmentRender.renderToStyle((CssStyle)textTdCssStyle, (Alignment)((Alignment)rc.getRP("textAlignment", fallbackStyle)));
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            textTdCssStyle.setAttribute("white-space", "nowrap");
        }
        textTdElement.setAttribute("style", textTdCssStyle.renderInline());
        for (int i = 0; i < textNodes.length; ++i) {
            textTdElement.appendChild(textNodes[i]);
        }
    }

    protected int convertIconTextPositionToOrientation(Alignment alignment, Component component) {
        if (alignment == null) {
            return 1;
        }
        if (alignment.getVertical() == 0) {
            if (alignment.getHorizontal() == 3) {
                return 0;
            }
            return 1;
        }
        if (alignment.getVertical() == 6) {
            return 2;
        }
        return 3;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(BUTTON_SERVICE);
    }
}

