/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer.command;

import echopointng.command.AttributesAdd;
import echopointng.command.JavaScriptEval;
import echopointng.command.JavaScriptInclude;
import echopointng.command.Print;
import echopointng.ui.resource.Resources;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.webcontainer.CommandSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

public class GeneralCommandPeer
implements CommandSynchronizePeer {
    public static final Service COMMAND_SERVICE = JavaScriptService.forResource((String)"EPNG.Command", (String)"/echopointng/ui/resource/js/command.js");

    public void render(RenderContext rc, Command command) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(COMMAND_SERVICE.getId());
        if (command instanceof Print) {
            this.renderPrintCommand(rc, (Print)command);
        } else if (command instanceof AttributesAdd) {
            this.renderAttributesAdd(rc, (AttributesAdd)command);
        } else if (command instanceof JavaScriptEval) {
            this.renderEvalJS(rc, (JavaScriptEval)command);
        } else if (command instanceof JavaScriptInclude) {
            this.renderIncludeJS(rc, (JavaScriptInclude)command);
        } else {
            throw new IllegalArgumentException("Unhandled Command type : " + String.valueOf(command));
        }
    }

    private void renderAttributesAdd(RenderContext rc, AttributesAdd command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCommand.MessageProcessor", "attributesAdd");
        itemE.setAttribute("eid", ContainerInstance.getElementId((Component)command.getComponent()));
        String[] names = command.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            Element attrE = serverMessage.getDocument().createElement("attribute");
            itemE.appendChild(attrE);
            attrE.setAttribute("name", names[i]);
            attrE.setAttribute("value", String.valueOf(command.getAttribute(names[i])));
        }
    }

    private void renderPrintCommand(RenderContext rc, Print command) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.appendPartDirective("postupdate", "EPCommand.MessageProcessor", "print");
    }

    private void renderEvalJS(RenderContext rc, JavaScriptEval command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCommand.MessageProcessor", "evalJS");
        CDATASection cdata = serverMessage.getDocument().createCDATASection(command.getJavaScript());
        itemE.appendChild(cdata);
    }

    private void renderIncludeJS(RenderContext rc, JavaScriptInclude command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCommand.MessageProcessor", "includeJS");
        itemE.setAttribute("javascriptURI", command.getJavaScriptURI());
    }

    static {
        WebRenderServlet.getServiceRegistry().add(COMMAND_SERVICE);
    }
}

