/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Command;
import nextapp.echo2.webcontainer.CommandSynchronizePeer;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import nextapp.echo2.webcontainer.command.BrowserRedirectCommand;
import nextapp.echo2.webcontainer.command.BrowserSetCookieCommand;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class BrowserCommandPeer
implements CommandSynchronizePeer {
    private static final Service BROWSER_COMMAND_SERVICE = JavaScriptService.forResource((String)"Echo.BrowserCommand", (String)"/nextapp/echo2/webcontainer/resource/js/BrowserCommand.js");

    public void render(RenderContext rc, Command command) {
        if (command instanceof BrowserOpenWindowCommand) {
            this.renderOpenWindow(rc, (BrowserOpenWindowCommand)command);
        } else if (command instanceof BrowserRedirectCommand) {
            this.renderRedirect(rc, (BrowserRedirectCommand)command);
        } else if (command instanceof BrowserSetCookieCommand) {
            this.renderSetCookie(rc, (BrowserSetCookieCommand)command);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void renderSetCookie(RenderContext rc, BrowserSetCookieCommand command) {
        rc.getConnection().getResponse().addCookie(command.getCookie());
    }

    private void renderOpenWindow(RenderContext rc, BrowserOpenWindowCommand command) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(BROWSER_COMMAND_SERVICE.getId());
        Element openWindowElement = serverMessage.appendPartDirective("postupdate", "EchoBrowserCommand.MessageProcessor", "open-window");
        openWindowElement.setAttribute("uri", command.getUri());
        if (command.getName() != null) {
            openWindowElement.setAttribute("name", command.getName());
        }
        if (command.getFeatures() != null) {
            openWindowElement.setAttribute("features", command.getFeatures());
        }
        openWindowElement.setAttribute("replace", command.isReplace() ? "true" : "false");
    }

    private void renderRedirect(RenderContext rc, BrowserRedirectCommand command) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(BROWSER_COMMAND_SERVICE.getId());
        Element redirectElement = serverMessage.appendPartDirective("postupdate", "EchoBrowserCommand.MessageProcessor", "redirect");
        redirectElement.setAttribute("uri", command.getUri());
    }

    static {
        WebRenderServlet.getServiceRegistry().add(BROWSER_COMMAND_SERVICE);
    }
}

