/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.attempto.chartparser;

import ch.uzh.ifi.attempto.chartparser.Nonterminal;
import ch.uzh.ifi.attempto.chartparser.Rule;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar {
    private final Nonterminal startCategory;
    private ArrayList<Rule> rules = new ArrayList();
    private HashMap<String, ArrayList<Rule>> rulesByHeadName = new HashMap();
    private ArrayList<Rule> epsilonRules = new ArrayList();

    public Grammar(Nonterminal nonterminal) {
        this.startCategory = nonterminal;
    }

    public Grammar(String string) {
        this.startCategory = new Nonterminal(string);
    }

    public Nonterminal getStartCategory() {
        return this.startCategory;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        ArrayList<Rule> arrayList = this.rulesByHeadName.get(rule.getHead().getName());
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(rule);
            this.rulesByHeadName.put(rule.getHead().getName(), arrayList);
        } else {
            arrayList.add(rule);
        }
        this.rulesByHeadName.get(rule.getHead().getName()).add(rule);
        if (rule.hasEmptyBody()) {
            this.epsilonRules.add(rule);
        }
    }

    public ArrayList<Rule> getRulesByHeadName(String string) {
        ArrayList<Rule> arrayList = this.rulesByHeadName.get(string);
        if (arrayList != null) {
            return arrayList;
        }
        return new ArrayList<Rule>();
    }

    public ArrayList<Rule> getEpsilonRules() {
        return this.epsilonRules;
    }

    public String toString() {
        String string = "";
        for (Rule rule : this.rules) {
            string = string + rule + "\n";
        }
        return string;
    }
}

