/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.BorderEx;
import echopointng.DateChooser;
import echopointng.DropDown;
import echopointng.MutableStyleEx;
import echopointng.model.CalendarEvent;
import echopointng.model.CalendarSelectionListener;
import echopointng.model.CalendarSelectionModel;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.DocumentListener;

public class DateField
extends DropDown {
    public static final Style DEFAULT_TEXT_FIELD_STYLE;
    private DateFormat dateFormat;
    private InternalListener internalListener = new InternalListener();
    private boolean selectionPending = false;
    private boolean expansionOverride = false;
    private boolean updateFromTextField = true;

    public DateField() {
        this(Calendar.getInstance());
    }

    public DateField(Calendar startDate) {
        this.setDateFormat(DateFormat.getDateInstance());
        TextField tf = new TextField();
        tf.setStyle(DEFAULT_TEXT_FIELD_STYLE);
        this.setTextField(tf);
        DateChooser dc = new DateChooser();
        this.setDateChooser(dc);
        dc.setSelectedDate(startDate);
    }

    public void processInput(String inputName, Object inputValue) {
        if (!this.expansionOverride) {
            super.processInput(inputName, inputValue);
        }
        this.expansionOverride = false;
    }

    public DateChooser getDateChooser() {
        return (DateChooser)this.getPopUp();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Calendar getDisplayedDate() {
        if (this.getModel() != null) {
            return this.getModel().getDisplayedDate();
        }
        return null;
    }

    public CalendarSelectionModel getModel() {
        if (this.getDateChooser() != null) {
            return this.getDateChooser().getModel();
        }
        return null;
    }

    public Calendar getSelectedDate() {
        if (this.getModel() != null) {
            return this.getModel().getSelectedDate();
        }
        return null;
    }

    public TextField getTextField() {
        return (TextField)this.getTarget();
    }

    public String getText() {
        TextField textField = this.getTextField();
        if (textField != null) {
            return textField.getText();
        }
        return null;
    }

    public boolean isUpdateFromTextField() {
        return this.updateFromTextField;
    }

    public void setDateChooser(DateChooser newValue) {
        if (newValue == null || newValue.getModel() == null) {
            throw new IllegalArgumentException("The DateChooser and its CalendarSelectionModel must be non null.");
        }
        DateChooser oldValue = this.getDateChooser();
        if (oldValue != null) {
            oldValue.getModel().removeListener(this.internalListener);
        }
        newValue.getModel().addListener(this.internalListener);
        this.setPopUp(newValue);
    }

    public void setDateFormat(DateFormat newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("The DateFormat must be non null.");
        }
        this.dateFormat = newValue;
    }

    public void setDisplayedDate(Calendar newDisplayedDate) {
        this.getModel().setDisplayedDate(newDisplayedDate);
    }

    public void setModel(CalendarSelectionModel newValue) {
        CalendarSelectionModel oldValue = this.getModel();
        if (newValue != oldValue) {
            oldValue.removeListener(this.internalListener);
            if (newValue != null) {
                newValue.addListener(this.internalListener);
            }
            if (this.getDateChooser() != null) {
                this.getDateChooser().setModel(newValue);
            }
            this.updateTextFromDate();
        }
    }

    public void setSelectedDate(Calendar newSelectedDate) {
        this.getModel().setSelectedDate(newSelectedDate);
    }

    public void setTextField(TextField newValue) {
        if (newValue == null || newValue.getDocument() == null) {
            throw new IllegalArgumentException("The TextField and its Document must be non null.");
        }
        TextField oldValue = this.getTextField();
        if (oldValue != null) {
            oldValue.getDocument().removeDocumentListener((DocumentListener)this.internalListener);
        }
        newValue.getDocument().addDocumentListener((DocumentListener)this.internalListener);
        this.setTarget((Component)newValue);
    }

    public void setUpdateFromTextField(boolean newValue) {
        this.updateFromTextField = newValue;
    }

    protected void updateDateFromText() {
        if (!this.isUpdateFromTextField()) {
            return;
        }
        this.selectionPending = true;
        String text = this.getTextField().getText();
        if (this.dateFormat != null) {
            try {
                Date date = this.dateFormat.parse(text);
                Locale locale = this.getLocale();
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                Calendar cal = Calendar.getInstance(locale);
                cal.setTime(date);
                this.getModel().setDates(cal, cal);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.selectionPending = false;
    }

    protected void updateTextFromDate() {
        this.selectionPending = true;
        CalendarSelectionModel model = this.getModel();
        String text = "";
        if (model.getSelectedDate() != null) {
            text = this.getDateFormat().format(model.getSelectedDate().getTime());
        }
        this.getTextField().setText(text);
        this.selectionPending = false;
    }

    public void validate() {
        super.validate();
        this.selectionPending = false;
        this.expansionOverride = false;
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", (Object)new BorderEx(0, null, 0));
        DEFAULT_TEXT_FIELD_STYLE = style;
    }

    private class InternalListener
    implements CalendarSelectionListener,
    DocumentListener,
    Serializable {
        private InternalListener() {
        }

        public void displayedDateChange(CalendarEvent calEvent) {
        }

        public void documentUpdate(DocumentEvent e) {
            if (DateField.this.selectionPending) {
                return;
            }
            DateField.this.updateDateFromText();
            DateField.this.expansionOverride = true;
            DateField.this.setExpanded(true);
            DateField.this.setExpanded(false);
        }

        public void selectedDateChange(CalendarEvent calEvent) {
            if (DateField.this.selectionPending) {
                return;
            }
            if (!DateField.this.updateFromTextField) {
                return;
            }
            DateField.this.updateTextFromDate();
            DateField.this.expansionOverride = true;
            DateField.this.setExpanded(true);
            DateField.this.setExpanded(false);
        }
    }
}

