/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.history.HistoryEvent;
import echopointng.history.HistoryEventListener;
import echopointng.history.HistoryState;
import echopointng.history.HistoryUndoRedo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.EventListenerList;

public class HistoryMonitor
extends Component {
    public static final String HISTORY_CHANGED_PROPERTY = "historyChanged";
    protected EventListenerList listenerList = new EventListenerList();
    protected List historyStateList = this.generateHistoryList();
    protected List pendingHistoryStateList = new ArrayList();
    private int currentHistoryIndex = -1;

    protected List generateHistoryList() {
        return new ArrayList();
    }

    public void addHistoryEventListener(HistoryEventListener l) {
        this.listenerList.addListener(HistoryEventListener.class, (EventListener)l);
    }

    public void removeHistoryEventListener(HistoryEventListener l) {
        this.listenerList.removeListener(HistoryEventListener.class, (EventListener)l);
    }

    private void validate(HistoryState historyState) {
        if (historyState == null) {
            throw new IllegalArgumentException("The HistoryState must be not be null!");
        }
        String historyHash = historyState.historyHash();
        if (historyHash == null) {
            throw new IllegalArgumentException("The HistoryState historyHash must be non null");
        }
        int index = this.getIndexOfHistory(historyHash);
        if (index != -1) {
            throw new IllegalStateException("A HistoryState object is already in the history cache with the historyHash : " + historyState.historyHash());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(HistoryState historyState) {
        this.validate(historyState);
        List list = this.pendingHistoryStateList;
        synchronized (list) {
            this.historyStateList.add(historyState);
            this.pendingHistoryStateList.add(historyState);
            if (this.currentHistoryIndex == this.historyStateList.size() - 2) {
                this.currentHistoryIndex = this.historyStateList.size() - 1;
            }
        }
        this.firePropertyChange(HISTORY_CHANGED_PROPERTY, null, null);
    }

    public List getHistory() {
        return Collections.unmodifiableList(this.historyStateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        List list = this.pendingHistoryStateList;
        synchronized (list) {
            this.historyStateList.clear();
            this.pendingHistoryStateList.clear();
            this.currentHistoryIndex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistoryInFrontOf(HistoryState historyState) {
        this.validate(historyState);
        int index = this.getIndexOfHistory(historyState.historyHash());
        List list = this.pendingHistoryStateList;
        synchronized (list) {
            for (int i = this.historyStateList.size() - 1; i > index; --i) {
                HistoryState state = (HistoryState)this.historyStateList.get(i);
                if (this.pendingHistoryStateList.contains(state)) {
                    this.pendingHistoryStateList.remove(state);
                }
                this.historyStateList.remove(i);
            }
            if (this.currentHistoryIndex > index) {
                this.currentHistoryIndex = index;
            }
        }
    }

    public HistoryState getCurrent() {
        if (this.currentHistoryIndex >= 0) {
            return (HistoryState)this.historyStateList.get(this.currentHistoryIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPendingHistory() {
        List list = this.pendingHistoryStateList;
        synchronized (list) {
            ArrayList newPendingList = new ArrayList(this.pendingHistoryStateList);
            this.pendingHistoryStateList.clear();
            return newPendingList;
        }
    }

    protected int getIndexOfHistory(String historyHash) {
        for (int i = this.historyStateList.size() - 1; i >= 0; --i) {
            HistoryState testUndoRedo = (HistoryState)this.historyStateList.get(i);
            if (!testUndoRedo.historyHash().equals(historyHash)) continue;
            return i;
        }
        return -1;
    }

    protected HistoryState[] getHistoryBetween(int startIndex, int endIndex) {
        ArrayList<HistoryState> tempList = new ArrayList<HistoryState>();
        if (endIndex < startIndex) {
            for (int i = startIndex; i > endIndex; --i) {
                HistoryState historyState = (HistoryState)this.historyStateList.get(i);
                tempList.add(historyState);
            }
        } else {
            for (int i = startIndex + 1; i <= endIndex; ++i) {
                HistoryState historyState = (HistoryState)this.historyStateList.get(i);
                tempList.add(historyState);
            }
        }
        return tempList.toArray(new HistoryState[tempList.size()]);
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        String historyHash = String.valueOf(inputValue);
        int startIndex = this.currentHistoryIndex;
        int endIndex = this.getIndexOfHistory(historyHash);
        boolean isRedo = endIndex >= startIndex;
        this.currentHistoryIndex = endIndex;
        HistoryState[] historyStates = this.getHistoryBetween(startIndex, endIndex);
        for (int i = 0; i < historyStates.length; ++i) {
            HistoryState historyState = historyStates[i];
            if (historyState instanceof HistoryUndoRedo) {
                HistoryUndoRedo undoRedo = (HistoryUndoRedo)historyState;
                if (isRedo) {
                    undoRedo.redo();
                } else {
                    undoRedo.undo();
                }
            }
            this.fireEventListeners(new HistoryEvent((Object)this, historyState), true, isRedo);
        }
        if (endIndex == -1) {
            this.fireEventListeners(new HistoryEvent((Object)this, null), false, false);
        }
    }

    private void fireEventListeners(HistoryEvent historyEvent, boolean foundHistory, boolean isRedo) {
        EventListener[] listeners = this.listenerList.getListeners(HistoryEventListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            HistoryEventListener listener = (HistoryEventListener)listeners[index];
            if (foundHistory) {
                if (isRedo) {
                    listener.onRedo(historyEvent);
                    continue;
                }
                listener.onUndo(historyEvent);
                continue;
            }
            listener.onNoHistoryAvailable(historyEvent);
        }
    }
}

