/*
 * Decompiled with CFR 0.152.
 */
package echopointng.model;

import echopointng.model.BoundedRangeModel;
import java.io.Serializable;
import java.util.EventListener;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.event.EventListenerList;

public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int value = 0;
    private int extent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;

    public DefaultBoundedRangeModel() {
    }

    public DefaultBoundedRangeModel(int value, int extent, int min, int max) {
        if (max < min || value < min || value + extent < value || value + extent > max) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = value;
        this.extent = extent;
        this.min = min;
        this.max = max;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.addListener(ChangeListener.class, (EventListener)l);
    }

    public void fireStateChanged() {
        EventListener[] listeners = this.listenerList.getListeners(ChangeListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent((Object)this);
            }
            ((ChangeListener)listeners[index]).stateChanged(this.changeEvent);
        }
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getValue() {
        return this.value;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.removeListener(ChangeListener.class, (EventListener)l);
    }

    public void setExtent(int n) {
        int newExtent = Math.max(0, n);
        if (this.value + newExtent > this.max) {
            newExtent = this.max - this.value;
        }
        this.setRangeProperties(this.value, newExtent, this.min, this.max, this.isAdjusting);
    }

    public void setMaximum(int n) {
        int newMin = Math.min(n, this.min);
        int newValue = Math.min(n, this.value);
        int newExtent = Math.min(n - newValue, this.extent);
        this.setRangeProperties(newValue, newExtent, newMin, n, this.isAdjusting);
    }

    public void setMinimum(int n) {
        int newMax = Math.max(n, this.max);
        int newValue = Math.max(n, this.value);
        int newExtent = Math.min(newMax - newValue, this.extent);
        this.setRangeProperties(newValue, newExtent, n, newMax, this.isAdjusting);
    }

    public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
        boolean isChange;
        if (newMin > newMax) {
            newMin = newMax;
        }
        if (newValue > newMax) {
            newMax = newValue;
        }
        if (newValue < newMin) {
            newMin = newValue;
        }
        if ((long)newExtent + (long)newValue > (long)newMax) {
            newExtent = newMax - newValue;
        }
        if (newExtent < 0) {
            newExtent = 0;
        }
        boolean bl = isChange = newValue != this.value || newExtent != this.extent || newMin != this.min || newMax != this.max || adjusting != this.isAdjusting;
        if (isChange) {
            this.value = newValue;
            this.extent = newExtent;
            this.min = newMin;
            this.max = newMax;
            this.isAdjusting = adjusting;
            this.fireStateChanged();
        }
    }

    public void setValue(int n) {
        int newValue = Math.max(n, this.min);
        if (newValue + this.extent > this.max) {
            newValue = this.max - this.extent;
        }
        this.setRangeProperties(newValue, this.extent, this.min, this.max, this.isAdjusting);
    }

    public void setValueIsAdjusting(boolean b) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, b);
    }

    public String toString() {
        String modelString = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + modelString + "]";
    }
}

