/*
 * Decompiled with CFR 0.152.
 */
package echopointng.progressbar;

import echopointng.EPNG;
import echopointng.ProgressBar;
import echopointng.progressbar.ProgressBarRenderer;
import echopointng.util.ColorKit;
import echopointng.util.FontKit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import nextapp.echo2.app.AwtImageReference;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;

public class DefaultProgressBarRenderer
implements ProgressBarRenderer,
Serializable {
    int borderSize = 0;
    int height = 0;
    int hspacer = 2;
    private boolean isHorz;
    ProgressBar pb = null;
    int vspacer = 2;
    int width = 0;

    private void _drawBlocks(Graphics2D g, int numBlocks, int blockWidth, int blockHeight, int partialDraw, Color clr) {
        int x = 0 + this.hspacer + this.borderSize;
        int y = 0 + this.vspacer + this.borderSize;
        if (!this._isHorz()) {
            y = this.height - this.borderSize - blockHeight;
        }
        for (int i = 0; i < numBlocks; ++i) {
            g.setColor(clr);
            int drawWidth = blockWidth;
            int drawHeight = blockHeight;
            int drawX = x;
            int drawY = y;
            if (this._isHorz()) {
                drawWidth -= this.hspacer;
                if (i == numBlocks - 1 && partialDraw > 0) {
                    drawWidth = partialDraw;
                }
                x += blockWidth;
            } else {
                drawHeight -= this.vspacer;
                if (i == numBlocks - 1 && partialDraw > 0) {
                    drawY = y + (drawHeight - partialDraw);
                    drawHeight = partialDraw;
                }
                y -= blockHeight;
            }
            g.fillRect(drawX, drawY, drawWidth, drawHeight);
        }
    }

    private void _drawText(Graphics2D g, float w, float h, String s, Color foreGround) {
        if (s == null) {
            return;
        }
        FontRenderContext frc = g.getFontRenderContext();
        Font fnt = FontKit.makeAwtFont(this._findFont(this.pb), new Font("Verdana", 1, 12));
        g.setColor(foreGround);
        g.setFont(fnt);
        TextLayout tl = new TextLayout(s, fnt, frc);
        Rectangle rect = tl.getBounds().getBounds();
        float y = ((float)this.height - (float)rect.getHeight()) / 2.0f;
        y += (float)rect.getHeight();
        int rotateDegress = 0;
        rotateDegress = this._isHorz() || rect.getWidth() < (double)this.width ? 0 : 90;
        float fx = w / 2.0f;
        float fy = h / 2.0f;
        float x1 = fx - (float)(rect.width / 2);
        float y1 = fy + (float)(rect.height / 2) - tl.getDescent();
        AffineTransform atPrev = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        at.rotate(Math.toRadians(rotateDegress), fx, fy);
        at.translate(x1, y1);
        g.setTransform(at);
        tl.draw(g, 0.0f, 0.0f);
        g.setTransform(atPrev);
    }

    private nextapp.echo2.app.Font _findFont(Component c) {
        nextapp.echo2.app.Font fnt = c.getFont();
        while (c != null && fnt == null) {
            if ((c = c.getParent()) == null) continue;
            fnt = c.getFont();
        }
        return fnt;
    }

    private boolean _isHorz() {
        return this.isHorz;
    }

    public ImageReference drawProgressBar(ProgressBar progressBar) {
        boolean isPainted;
        int innerHeight;
        int innerWidth;
        Style fallbackStyle = EPNG.getFallBackStyle(progressBar);
        this.pb = progressBar;
        Integer intObj = (Integer)this.getRP(this.pb, "orientation", fallbackStyle);
        this.isHorz = 0 == (intObj == null ? 0 : intObj);
        intObj = (Integer)this.getRP(this.pb, "numberOfBlocks", fallbackStyle);
        int TOTAL_NUM_BLOCKS = intObj == null ? 10 : intObj;
        Border border = (Border)this.getRP(this.pb, "border", fallbackStyle);
        nextapp.echo2.app.Color borderColor = border == null ? null : border.getColor();
        Color clrBorder = ColorKit.makeAwtColor(borderColor, Color.black);
        Color clrBackground = ColorKit.makeAwtColor(this.getRPColor(this.pb, "background", fallbackStyle), Color.white);
        Color clrForeGround = ColorKit.makeAwtColor(this.getRPColor(this.pb, "foreground", fallbackStyle), Color.black);
        Color clrCompleted = ColorKit.makeAwtColor(this.getRPColor(this.pb, "completedColor", fallbackStyle), Color.orange);
        Color clrUncompleted = ColorKit.makeAwtColor(this.getRPColor(this.pb, "uncompletedColor", fallbackStyle), Color.lightGray);
        this.hspacer = 2;
        this.vspacer = 2;
        this.borderSize = border != null && border.getSize() != null ? border.getSize().getValue() : 0;
        this.borderSize = 0;
        Extent widthExt = (Extent)this.getRP(this.pb, "width", fallbackStyle);
        this.width = widthExt != null ? widthExt.getValue() : 146;
        Extent heightExt = (Extent)this.getRP(this.pb, "height", fallbackStyle);
        this.height = heightExt != null ? heightExt.getValue() : 30;
        int blockHeight = 0;
        int blockWidth = 0;
        int leftOver = 0;
        if (this._isHorz()) {
            innerWidth = this.width - this.hspacer * 1 - this.borderSize * 2;
            blockHeight = innerHeight = this.height - this.vspacer * 2 - this.borderSize * 2;
            blockWidth = innerWidth / TOTAL_NUM_BLOCKS;
            leftOver = innerWidth - blockWidth * TOTAL_NUM_BLOCKS;
            if (leftOver > 0) {
                this.width -= leftOver;
                leftOver = 0;
            }
        } else {
            innerWidth = this.width - this.hspacer * 2 - this.borderSize * 2;
            innerHeight = this.height - this.vspacer * 1 - this.borderSize * 2;
            blockWidth = innerWidth;
            blockHeight = innerHeight / TOTAL_NUM_BLOCKS;
            leftOver = innerHeight - blockHeight * TOTAL_NUM_BLOCKS;
            if (leftOver > 0) {
                this.height -= leftOver;
                leftOver = 0;
            }
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.borderSize > 0) {
            g.setColor(clrBorder);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.white);
            g.fillRect(this.borderSize, this.borderSize, this.width - this.borderSize * 2, this.height - this.borderSize * 2);
        } else {
            g.setColor(clrBackground);
            g.fillRect(0, 0, this.width, this.height);
        }
        this._drawBlocks(g, TOTAL_NUM_BLOCKS, blockWidth, blockHeight, 0, clrUncompleted);
        int partialDraw = 0;
        double pcDoneOrig = 100.0 * this.pb.getPercentComplete();
        double pcDone = Math.round(pcDoneOrig);
        pcDone /= 100.0;
        if (pcDone > 0.0) {
            double numBlocks = (double)TOTAL_NUM_BLOCKS * pcDone;
            double rem = numBlocks - Math.floor(numBlocks);
            if (rem > 0.0) {
                numBlocks += 1.0;
                partialDraw = this._isHorz() ? (int)(rem * (double)(blockWidth - this.hspacer)) : (int)(rem * (double)(blockHeight - this.vspacer));
            }
            this._drawBlocks(g, (int)Math.floor(numBlocks), blockWidth, blockHeight, partialDraw, clrCompleted);
        }
        if (isPainted = Boolean.TRUE.equals(this.getRP(this.pb, "progressStringPainted", fallbackStyle))) {
            String text = (String)this.getRP(this.pb, "progressStringPainted", fallbackStyle);
            this._drawText(g, this.width, this.height, text, clrForeGround);
        }
        g.dispose();
        return new AwtImageReference((Image)image);
    }

    private Object getRP(Component c, String propertyName, Style fallbackStyle) {
        Object value = c.getRenderProperty(propertyName);
        if (value == null && fallbackStyle != null) {
            value = fallbackStyle.getProperty(propertyName);
        }
        return value;
    }

    private nextapp.echo2.app.Color getRPColor(Component c, String propertyName, Style fallbackStyle) {
        Object value = c.getRenderProperty(propertyName);
        if (value == null && fallbackStyle != null) {
            value = fallbackStyle.getProperty(propertyName);
        }
        return (nextapp.echo2.app.Color)value;
    }

    public String toString() {
        return "w=" + this.width + " h=" + this.height + " hs=" + this.hspacer + " vs=" + this.vspacer + " bs=" + this.borderSize;
    }
}

