/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssObjectDeclarationParser;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.propertypeer.AbstractCssPropertyPeer;
import echopointng.util.ExtentKit;
import nextapp.echo2.app.Insets;

public class InsetsPeer
extends AbstractCssPropertyPeer {
    protected Class getConversionClass() {
        return Insets.class;
    }

    protected boolean canConvert(CssObjectIntrospector ci, String propertyValue) {
        if (InsetsPeer.isNullString(propertyValue)) {
            return true;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (tokens[0].equalsIgnoreCase("insets")) {
            if (tokens.length != 2 && tokens.length != 3 && tokens.length != 5) {
                return false;
            }
            if (tokens.length == 5) {
                String l = tokens[1].trim();
                String t = tokens[2].trim();
                String r = tokens[3].trim();
                String b = tokens[4].trim();
                return ExtentKit.isExtent(l) && ExtentKit.isExtent(t) && ExtentKit.isExtent(r) && ExtentKit.isExtent(b);
            }
            if (tokens.length == 3) {
                String w = tokens[1].trim();
                String h = tokens[2].trim();
                return ExtentKit.isExtent(w) && ExtentKit.isExtent(h);
            }
            if (tokens.length == 2) {
                String w = tokens[1].trim();
                return ExtentKit.isExtent(w);
            }
        }
        return false;
    }

    protected Object getObject(CssObjectIntrospector ci, String propertyValue) {
        if (InsetsPeer.isNullString(propertyValue)) {
            return null;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (tokens.length == 5) {
            String l = tokens[1].trim();
            String t = tokens[2].trim();
            String r = tokens[3].trim();
            String b = tokens[4].trim();
            return new Insets(ExtentKit.makeExtent(l), ExtentKit.makeExtent(t), ExtentKit.makeExtent(r), ExtentKit.makeExtent(b));
        }
        if (tokens.length == 3) {
            String w = tokens[1].trim();
            String h = tokens[2].trim();
            return new Insets(ExtentKit.makeExtent(w), ExtentKit.makeExtent(h));
        }
        String w = tokens[1].trim();
        return new Insets(ExtentKit.makeExtent(w));
    }

    protected String getString(CssObjectIntrospector ci, Object object) {
        Insets value = (Insets)object;
        StringBuffer sb = new StringBuffer();
        sb.append("insets(");
        sb.append(value.getLeft());
        sb.append(",");
        sb.append(value.getTop());
        sb.append(",");
        sb.append(value.getRight());
        sb.append(",");
        sb.append(value.getBottom());
        sb.append(")");
        return sb.toString();
    }
}

