/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.BorderEx;
import echopointng.ExtentEx;
import echopointng.table.SortableTableModel;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableCellRenderer;

public class SortableTableHeaderRenderer
implements TableCellRenderer {
    public static final ImageReference DEFAULT_UP_ARROW_IMAGE = new ResourceImageReference("/echopointng/resource/images/ArrowUp.gif");
    public static final ImageReference DEFAULT_DOWN_ARROW_IMAGE = new ResourceImageReference("/echopointng/resource/images/ArrowDown.gif");
    public static final Color DEFAULT_BACKGROUND = new Color(175, 175, 239);
    public static final BorderEx DEFAULT_BORDER = new BorderEx(DEFAULT_BACKGROUND);
    public static final Insets DEFAULT_INSETS = new Insets(1);
    public static final TableLayoutData DEFAULT_LAYOUT_DATA = new TableLayoutData();
    private ImageReference upArrowImage = DEFAULT_UP_ARROW_IMAGE;
    private ImageReference downArrowImage = DEFAULT_DOWN_ARROW_IMAGE;
    private Color background = DEFAULT_BACKGROUND;
    private BorderEx border = DEFAULT_BORDER;
    private Insets insets = DEFAULT_INSETS;
    private TableLayoutData layoutData = DEFAULT_LAYOUT_DATA;

    public SortableTableHeaderRenderer() {
        this.layoutData.setBackground(this.background);
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        SortableTableModel model = (SortableTableModel)table.getModel();
        return this.getSortButton((String)value, column, model);
    }

    protected Button getSortButton(String label, int column, SortableTableModel model) {
        Button button = new Button(label);
        button.addActionListener(this.getSortButtonListener(column, model));
        button.setLayoutData((LayoutData)this.getLayoutData());
        button.setInsets(this.getInsets());
        button.setBackground(this.getBackground());
        button.setBorder((Border)this.getBorder());
        button.setTextPosition(new Alignment(3, 0));
        button.setWidth((Extent)new ExtentEx("100%"));
        Object icon = null;
        if (model.getCurrentSortColumn() == column) {
            int sortDirective = model.getSortDirective(column);
            icon = sortDirective == 1 ? this.getUpArrowImage() : (sortDirective == -1 ? this.getDownArrowImage() : null);
            button.setIcon(icon);
        }
        return button;
    }

    protected ActionListener getSortButtonListener(final int column, final SortableTableModel model) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int sortDirective = model.getSortDirective(column);
                int newSortDirective = sortDirective == 0 ? 1 : (sortDirective == 1 ? -1 : 0);
                model.sortByColumn(column, newSortDirective);
            }
        };
    }

    public ImageReference getUpArrowImage() {
        return this.upArrowImage;
    }

    public void setUpArrowImage(ImageReference upArrowImage) {
        this.upArrowImage = upArrowImage;
    }

    public ImageReference getDownArrowImage() {
        return this.downArrowImage;
    }

    public void setDownArrowImage(ImageReference downArrowImage) {
        this.downArrowImage = downArrowImage;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.layoutData.setBackground(background);
    }

    public BorderEx getBorder() {
        return this.border;
    }

    public void setBorder(BorderEx border) {
        this.border = border;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public TableLayoutData getLayoutData() {
        return this.layoutData;
    }

    public void setLayoutData(TableLayoutData layoutData) {
        this.layoutData = layoutData;
    }

    static {
        DEFAULT_LAYOUT_DATA.setBackground(DEFAULT_BACKGROUND);
    }
}

