/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.Calculator;
import echopointng.EPNG;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.HtmlTable;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CalculatorPeer
extends AbstractEchoPointPeer
implements PropertyUpdateProcessor,
ActionProcessor {
    private static final String nbsp = "\u00a0";
    public static final Service CALC_SERVICE = JavaScriptService.forResource((String)"EPNG.Calculator", (String)"/echopointng/ui/resource/js/calculator.js");

    public CalculatorPeer() {
        this.partialUpdateManager.add("text", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                Calculator calc = (Calculator)update.getParent();
                String text = calc.getText();
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPCalculator.MessageProcessor", "text", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)calc));
                itemElement.setAttribute("text", text);
                itemizedUpdateElement.appendChild(itemElement);
            }
        });
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        String propertyValue = propertyElement.getAttribute("value");
        if ("text".equals(propertyName)) {
            if (propertyValue != null && propertyValue.indexOf(46) == propertyValue.length() - 1) {
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "text", (Object)propertyValue);
        }
        if ("memory".equals(propertyName)) {
            if (propertyValue != null && propertyValue.indexOf(46) == propertyValue.length() - 1) {
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "memory", (Object)propertyValue);
        }
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "transfer", null);
    }

    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        Calculator calc = (Calculator)component;
        this.createInitDirective(rc, calc, fallbackStyle);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(CALC_SERVICE);
        String elementId = rc.getElementId();
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        style.setAttribute("white-space", "nowrap");
        HtmlTable table = new HtmlTable(rc.getDocument(), 0, 0, 0);
        parentNode.appendChild(table.getTABLE());
        table.getTABLE().setAttribute("id", elementId);
        table.getTABLE().setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(table.getTABLE());
        CssStyleEx cssInputStyleEx = new CssStyleEx();
        cssInputStyleEx.setBackground((Color)rc.getRP("displayBackground", fallbackStyle));
        cssInputStyleEx.setForeground((Color)rc.getRP("displayForeground", fallbackStyle));
        cssInputStyleEx.setFont((Font)rc.getRP("displayFont", fallbackStyle));
        cssInputStyleEx.setAttribute("width", "95%");
        cssInputStyleEx.setAttribute("text-align", "right");
        cssInputStyleEx.setAttribute("border", "none");
        cssInputStyleEx.setAttribute("padding-right", "2px");
        Element inputE = rc.createE("input");
        inputE.setAttribute("id", elementId + "Display");
        inputE.setAttribute("type", "text");
        inputE.setAttribute("value", calc.getText());
        inputE.setAttribute("style", cssInputStyleEx.renderInline());
        inputE.setAttribute("maxlength", "25");
        Element td = table.getTD();
        td.setAttribute("colspan", "6");
        td.setAttribute("align", "center");
        td.setAttribute("style", "padding:2px;");
        if (!rc.getComponent().isRenderEnabled()) {
            inputE.setAttribute("disabled", "disabled");
        }
        td.appendChild(inputE);
        table.newTR();
        CssStyleEx cssOperatorStyleEx = new CssStyleEx();
        Render.asColors(cssOperatorStyleEx, component, "buttonBackground", "buttonOperatorForeground", fallbackStyle);
        Render.asFont(cssOperatorStyleEx, component, "font", fallbackStyle);
        ExtentRender.renderToStyle((CssStyle)cssOperatorStyleEx, (String)"width", (Extent)((Extent)rc.getRP("buttonWidth", fallbackStyle)));
        ExtentRender.renderToStyle((CssStyle)cssOperatorStyleEx, (String)"height", (Extent)((Extent)rc.getRP("buttonHeight", fallbackStyle)));
        cssOperatorStyleEx.setAttribute("white-space", "nowrap");
        CssStyleEx cssNumberStyleEx = new CssStyleEx();
        Render.asColors(cssNumberStyleEx, component, "buttonBackground", "buttonNumberForeground", fallbackStyle);
        Render.asFont(cssNumberStyleEx, component, "font", fallbackStyle);
        ExtentRender.renderToStyle((CssStyle)cssNumberStyleEx, (String)"width", (Extent)((Extent)rc.getRP("buttonWidth", fallbackStyle)));
        ExtentRender.renderToStyle((CssStyle)cssNumberStyleEx, (String)"height", (Extent)((Extent)rc.getRP("buttonHeight", fallbackStyle)));
        cssNumberStyleEx.setAttribute("white-space", "nowrap");
        td = table.getTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "mc", "MC", false));
        td.appendChild(rc.createText(nbsp));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "7", "7", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "8", "8", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "9", "9", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "/", "/", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "sqrt", "sqrt", false));
        table.newTR();
        td = table.getTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "mr", "MR", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "4", "4", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "5", "5", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "6", "6", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "*", "*", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "%", "%", false));
        table.newTR();
        td = table.getTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "ms", "MS", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "1", "1", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "2", "2", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "3", "3", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "-", "-", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "1/x", "1/x", false));
        table.newTR();
        td = table.getTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "m+", "M+", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssNumberStyleEx, "0", "0", true));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "+/-", "+/-", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, ".", ".", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "+", "+", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "=", "=", true));
        table.newTR();
        td = table.getTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "c", "C", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "ce", "CE", false));
        td = table.newTD();
        td.appendChild(this.createButton(rc, cssOperatorStyleEx, "bksp", "BKSP", false));
        td = table.newTD();
        td.setAttribute("align", "center");
        td.setAttribute("style", "padding:5");
        td.appendChild(this.createPre(rc, elementId + "Memory", null));
        td = table.newTD();
        td.setAttribute("align", "center");
        td.setAttribute("style", "padding:5");
        td.appendChild(this.createPre(rc, elementId + "Operation", null));
        td = table.newTD();
        if (rc.getRP("transfer") != null) {
            td.appendChild(this.createButton(rc, cssOperatorStyleEx, "xfer", String.valueOf(rc.getRP("transfer")), true));
        } else {
            td.appendChild(rc.createText(nbsp));
        }
    }

    private Element createPre(RenderingContext rc, String id, String value) {
        Element pre = rc.createE("pre");
        pre.setAttribute("id", id);
        pre.setAttribute("style", "border:1px #f0f0f0 inset;margin-left:2px;margin-right:2px");
        Text textNode = rc.createText(value != null && value.length() > 0 ? value : nbsp);
        pre.appendChild(textNode);
        return pre;
    }

    private Element createButton(RenderingContext rc, CssStyleEx styleEx, String cmd, String text, boolean makeBold) {
        Element button = rc.createE("button");
        if (!rc.getComponent().isRenderEnabled()) {
            button.setAttribute("disabled", "disabled");
        }
        button.setAttribute("id", rc.getElementId() + "|" + cmd);
        button.setAttribute("style", styleEx.renderInline());
        Node textNode = rc.createText(text);
        if (makeBold) {
            Element boldE = rc.createE("b");
            boldE.appendChild(textNode);
            textNode = boldE;
        }
        button.appendChild(textNode);
        return button;
    }

    protected void createInitDirective(RenderingContext rc, Calculator calc, Style fallbackStyle) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPCalculator.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("enabled", String.valueOf(calc.isRenderEnabled()));
        itemElement.setAttribute("serverNotify", String.valueOf(calc.hasActionListeners()));
        itemElement.setAttribute("text", calc.getText());
        itemElement.setAttribute("memory", calc.getMemory());
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(CALC_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPCalculator.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(CALC_SERVICE);
    }
}

